/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.BackpressureOverflow$Strategy;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.BackpressureDrainManager;
import com.zoyi.rx.internal.util.BackpressureDrainManager$BackpressureQueueCallback;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class OperatorOnBackpressureBuffer$BufferSubscriber<T>
extends Subscriber<T>
implements BackpressureDrainManager$BackpressureQueueCallback {
    private final ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
    private final AtomicLong capacity;
    private final Subscriber<? super T> child;
    private final AtomicBoolean saturated = new AtomicBoolean(false);
    private final BackpressureDrainManager manager;
    private final NotificationLite<T> on = NotificationLite.instance();
    private final Action0 onOverflow;
    private final BackpressureOverflow$Strategy overflowStrategy;

    public OperatorOnBackpressureBuffer$BufferSubscriber(Subscriber<? super T> subscriber, Long l2, Action0 action0, BackpressureOverflow$Strategy backpressureOverflow$Strategy) {
        this.child = subscriber;
        this.capacity = l2 != null ? new AtomicLong(l2) : null;
        this.onOverflow = action0;
        this.manager = new BackpressureDrainManager(this);
        this.overflowStrategy = backpressureOverflow$Strategy;
    }

    @Override
    public final void onStart() {
        this.request(Long.MAX_VALUE);
    }

    @Override
    public final void onCompleted() {
        if (!this.saturated.get()) {
            this.manager.terminateAndDrain();
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (!this.saturated.get()) {
            this.manager.terminateAndDrain(throwable);
        }
    }

    @Override
    public final void onNext(T t2) {
        if (!this.assertCapacity()) {
            return;
        }
        this.queue.offer(this.on.next(t2));
        this.manager.drain();
    }

    @Override
    public final boolean accept(Object object) {
        return this.on.accept(this.child, object);
    }

    @Override
    public final void complete(Throwable throwable) {
        if (throwable != null) {
            this.child.onError(throwable);
            return;
        }
        this.child.onCompleted();
    }

    @Override
    public final Object peek() {
        return this.queue.peek();
    }

    @Override
    public final Object poll() {
        Object object = this.queue.poll();
        if (this.capacity != null && object != null) {
            this.capacity.incrementAndGet();
        }
        return object;
    }

    private boolean assertCapacity() {
        long l2;
        if (this.capacity == null) {
            return true;
        }
        do {
            boolean bl;
            block7: {
                if ((l2 = this.capacity.get()) > 0L) continue;
                bl = false;
                try {
                    bl = this.overflowStrategy.mayAttemptDrop() && this.poll() != null;
                }
                catch (MissingBackpressureException missingBackpressureException) {
                    if (!this.saturated.compareAndSet(false, true)) break block7;
                    this.unsubscribe();
                    this.child.onError(missingBackpressureException);
                }
            }
            if (this.onOverflow != null) {
                try {
                    this.onOverflow.call();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Exceptions.throwIfFatal(throwable);
                    this.manager.terminateAndDrain(throwable2);
                    return false;
                }
            }
            if (bl) continue;
            return false;
        } while (!this.capacity.compareAndSet(l2, l2 - 1L));
        return true;
    }

    protected final Producer manager() {
        return this.manager;
    }
}

