/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.operators.OperatorEagerConcatMap$EagerInnerSubscriber;
import com.zoyi.rx.internal.operators.OperatorEagerConcatMap$EagerOuterProducer;
import com.zoyi.rx.internal.operators.OperatorEagerConcatMap$EagerOuterSubscriber$1;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

final class OperatorEagerConcatMap$EagerOuterSubscriber<T, R>
extends Subscriber<T> {
    final Func1<? super T, ? extends Observable<? extends R>> mapper;
    final int bufferSize;
    final Subscriber<? super R> actual;
    final Queue<OperatorEagerConcatMap$EagerInnerSubscriber<R>> subscribers;
    volatile boolean done;
    Throwable error;
    volatile boolean cancelled;
    final AtomicInteger wip;
    private OperatorEagerConcatMap$EagerOuterProducer sharedProducer;

    public OperatorEagerConcatMap$EagerOuterSubscriber(Func1<? super T, ? extends Observable<? extends R>> func1, int n2, int n3, Subscriber<? super R> subscriber) {
        this.mapper = func1;
        this.bufferSize = n2;
        this.actual = subscriber;
        this.subscribers = new LinkedList<OperatorEagerConcatMap$EagerInnerSubscriber<R>>();
        this.wip = new AtomicInteger();
        this.request(n3 == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)n3);
    }

    final void init() {
        this.sharedProducer = new OperatorEagerConcatMap$EagerOuterProducer(this);
        this.add(Subscriptions.create(new OperatorEagerConcatMap$EagerOuterSubscriber$1(this)));
        this.actual.add(this);
        this.actual.setProducer(this.sharedProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanup() {
        Object object;
        Object object2 = this.subscribers;
        synchronized (object2) {
            object = new ArrayList<OperatorEagerConcatMap$EagerInnerSubscriber<R>>(this.subscribers);
            this.subscribers.clear();
        }
        object2 = object.iterator();
        while (object2.hasNext()) {
            object = (Subscription)object2.next();
            object.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onNext(T object) {
        Observable<R> observable;
        try {
            observable = this.mapper.call(object);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwOrReport(throwable, this.actual, object);
            return;
        }
        if (this.cancelled) {
            return;
        }
        OperatorEagerConcatMap$EagerInnerSubscriber operatorEagerConcatMap$EagerInnerSubscriber = new OperatorEagerConcatMap$EagerInnerSubscriber(this, this.bufferSize);
        object = this.subscribers;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.subscribers.add(operatorEagerConcatMap$EagerInnerSubscriber);
        }
        if (this.cancelled) {
            return;
        }
        observable.unsafeSubscribe(operatorEagerConcatMap$EagerInnerSubscriber);
        this.drain();
    }

    @Override
    public final void onError(Throwable throwable) {
        this.error = throwable;
        this.done = true;
        this.drain();
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int n2 = 1;
        OperatorEagerConcatMap$EagerOuterProducer operatorEagerConcatMap$EagerOuterProducer = this.sharedProducer;
        Subscriber<R> subscriber = this.actual;
        NotificationLite notificationLite = NotificationLite.instance();
        while (true) {
            boolean bl;
            OperatorEagerConcatMap$EagerInnerSubscriber<R> operatorEagerConcatMap$EagerInnerSubscriber;
            if (this.cancelled) {
                this.cleanup();
                return;
            }
            boolean bl2 = this.done;
            Queue<OperatorEagerConcatMap$EagerInnerSubscriber<R>> queue = this.subscribers;
            synchronized (queue) {
                operatorEagerConcatMap$EagerInnerSubscriber = this.subscribers.peek();
            }
            boolean bl3 = bl = operatorEagerConcatMap$EagerInnerSubscriber == null;
            if (bl2) {
                Throwable throwable = this.error;
                if (throwable != null) {
                    this.cleanup();
                    subscriber.onError(throwable);
                    return;
                }
                if (bl) {
                    subscriber.onCompleted();
                    return;
                }
            }
            if (!bl) {
                long l2 = operatorEagerConcatMap$EagerOuterProducer.get();
                long l3 = 0L;
                Queue<Object> queue2 = operatorEagerConcatMap$EagerInnerSubscriber.queue;
                boolean bl4 = false;
                while (true) {
                    boolean bl5 = operatorEagerConcatMap$EagerInnerSubscriber.done;
                    Object object = queue2.peek();
                    boolean bl6 = bl = object == null;
                    if (bl5) {
                        Object object2 = operatorEagerConcatMap$EagerInnerSubscriber.error;
                        if (object2 != null) {
                            this.cleanup();
                            subscriber.onError((Throwable)object2);
                            return;
                        }
                        if (bl) {
                            object2 = this.subscribers;
                            synchronized (object2) {
                                this.subscribers.poll();
                            }
                            operatorEagerConcatMap$EagerInnerSubscriber.unsubscribe();
                            bl4 = true;
                            this.request(1L);
                            break;
                        }
                    }
                    if (bl || l2 == l3) break;
                    queue2.poll();
                    try {
                        subscriber.onNext(notificationLite.getValue(object));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Exceptions.throwOrReport(throwable, subscriber, object);
                        return;
                    }
                    ++l3;
                }
                if (l3 != 0L) {
                    if (l2 != Long.MAX_VALUE) {
                        BackpressureUtils.produced(operatorEagerConcatMap$EagerOuterProducer, l3);
                    }
                    if (!bl4) {
                        operatorEagerConcatMap$EagerInnerSubscriber.requestMore(l3);
                    }
                }
                if (bl4) continue;
            }
            if ((n2 = this.wip.addAndGet(-n2)) == 0) break;
        }
    }
}

