/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.OnSubscribePublishMulticast$ParentSubscriber;
import com.zoyi.rx.internal.operators.OnSubscribePublishMulticast$PublishProducer;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public final class OnSubscribePublishMulticast<T>
extends AtomicInteger
implements Observable$OnSubscribe<T>,
Observer<T>,
Subscription {
    private static final long serialVersionUID = -3741892510772238743L;
    final Queue<T> queue;
    final int prefetch;
    final boolean delayError;
    final OnSubscribePublishMulticast$ParentSubscriber<T> parent;
    volatile boolean done;
    Throwable error;
    volatile Producer producer;
    volatile OnSubscribePublishMulticast$PublishProducer<T>[] subscribers;
    static final OnSubscribePublishMulticast$PublishProducer<?>[] EMPTY = new OnSubscribePublishMulticast$PublishProducer[0];
    static final OnSubscribePublishMulticast$PublishProducer<?>[] TERMINATED = new OnSubscribePublishMulticast$PublishProducer[0];

    public OnSubscribePublishMulticast(int n2, boolean bl) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + n2);
        }
        this.prefetch = n2;
        this.delayError = bl;
        this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<T>(n2) : new SpscAtomicArrayQueue<T>(n2);
        this.subscribers = EMPTY;
        this.parent = new OnSubscribePublishMulticast$ParentSubscriber(this);
    }

    @Override
    public final void call(Subscriber<? super T> subscriber) {
        Serializable serializable = new OnSubscribePublishMulticast$PublishProducer<T>(subscriber, this);
        subscriber.add((Subscription)((Object)serializable));
        subscriber.setProducer((Producer)((Object)serializable));
        if (this.add((OnSubscribePublishMulticast$PublishProducer<T>)serializable)) {
            if (serializable.isUnsubscribed()) {
                this.remove((OnSubscribePublishMulticast$PublishProducer<T>)serializable);
                return;
            }
            this.drain();
            return;
        }
        serializable = this.error;
        if (serializable != null) {
            subscriber.onError((Throwable)serializable);
            return;
        }
        subscriber.onCompleted();
    }

    @Override
    public final void onNext(T t2) {
        if (!this.queue.offer(t2)) {
            this.parent.unsubscribe();
            this.error = new MissingBackpressureException("Queue full?!");
            this.done = true;
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable throwable) {
        this.error = throwable;
        this.done = true;
        this.drain();
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.drain();
    }

    final void setProducer(Producer producer) {
        this.producer = producer;
        producer.request(this.prefetch);
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        Queue<T> queue = this.queue;
        int n2 = 0;
        do {
            long l2;
            Object object;
            int n3;
            long l3 = Long.MAX_VALUE;
            OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
            int n4 = this.subscribers.length;
            OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray2 = onSubscribePublishMulticast$PublishProducerArray;
            int n5 = onSubscribePublishMulticast$PublishProducerArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                object = onSubscribePublishMulticast$PublishProducerArray2[n3];
                l3 = Math.min(l3, object.get());
            }
            if (n4 == 0) continue;
            for (l2 = 0L; l2 != l3; ++l2) {
                n3 = this.done ? 1 : 0;
                object = queue.poll();
                int n6 = n4 = object == null ? 1 : 0;
                if (this.checkTerminated(n3 != 0, n4 != 0)) {
                    return;
                }
                if (n4 != 0) break;
                OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray3 = onSubscribePublishMulticast$PublishProducerArray;
                int n7 = onSubscribePublishMulticast$PublishProducerArray.length;
                for (n4 = 0; n4 < n7; ++n4) {
                    OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer = onSubscribePublishMulticast$PublishProducerArray3[n4];
                    onSubscribePublishMulticast$PublishProducer.actual.onNext((OnSubscribePublishMulticast$PublishProducer<T>[])object);
                }
            }
            if (l2 == l3 && this.checkTerminated(this.done, queue.isEmpty())) {
                return;
            }
            if (l2 == 0L) continue;
            Producer producer = this.producer;
            if (producer != null) {
                producer.request(l2);
            }
            object = onSubscribePublishMulticast$PublishProducerArray;
            n4 = onSubscribePublishMulticast$PublishProducerArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer = object[n3];
                BackpressureUtils.produced(onSubscribePublishMulticast$PublishProducer, l2);
            }
        } while ((n2 = this.addAndGet(-n2)) != 0);
    }

    final boolean checkTerminated(boolean bl, boolean bl2) {
        if (bl) {
            if (this.delayError) {
                if (bl2) {
                    OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray = this.terminate();
                    Throwable throwable = this.error;
                    if (throwable != null) {
                        OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray2 = onSubscribePublishMulticast$PublishProducerArray;
                        int n2 = onSubscribePublishMulticast$PublishProducerArray.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer = onSubscribePublishMulticast$PublishProducerArray2[i2];
                            onSubscribePublishMulticast$PublishProducer.actual.onError(throwable);
                        }
                    } else {
                        OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray3 = onSubscribePublishMulticast$PublishProducerArray;
                        int n3 = onSubscribePublishMulticast$PublishProducerArray.length;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer = onSubscribePublishMulticast$PublishProducerArray3[i3];
                            onSubscribePublishMulticast$PublishProducer.actual.onCompleted();
                        }
                    }
                    return true;
                }
            } else {
                Throwable throwable = this.error;
                if (throwable != null) {
                    OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray;
                    this.queue.clear();
                    OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray4 = onSubscribePublishMulticast$PublishProducerArray = this.terminate();
                    int n4 = onSubscribePublishMulticast$PublishProducerArray.length;
                    for (int i4 = 0; i4 < n4; ++i4) {
                        OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer = onSubscribePublishMulticast$PublishProducerArray4[i4];
                        onSubscribePublishMulticast$PublishProducer.actual.onError(throwable);
                    }
                    return true;
                }
                if (bl2) {
                    OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray;
                    OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray5 = onSubscribePublishMulticast$PublishProducerArray = this.terminate();
                    int n5 = onSubscribePublishMulticast$PublishProducerArray.length;
                    for (int i5 = 0; i5 < n5; ++i5) {
                        OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer = onSubscribePublishMulticast$PublishProducerArray5[i5];
                        onSubscribePublishMulticast$PublishProducer.actual.onCompleted();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final OnSubscribePublishMulticast$PublishProducer<T>[] terminate() {
        OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
        if (this.subscribers != TERMINATED) {
            OnSubscribePublishMulticast onSubscribePublishMulticast = this;
            synchronized (onSubscribePublishMulticast) {
                onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
                if (this.subscribers != TERMINATED) {
                    this.subscribers = TERMINATED;
                }
            }
        }
        return onSubscribePublishMulticast$PublishProducerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean add(OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer) {
        OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
        if (this.subscribers == TERMINATED) {
            return false;
        }
        OnSubscribePublishMulticast onSubscribePublishMulticast = this;
        synchronized (onSubscribePublishMulticast) {
            onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
            if (this.subscribers == TERMINATED) {
                return false;
            }
            int n2 = onSubscribePublishMulticast$PublishProducerArray.length;
            OnSubscribePublishMulticast$PublishProducer[] onSubscribePublishMulticast$PublishProducerArray2 = new OnSubscribePublishMulticast$PublishProducer[n2 + 1];
            System.arraycopy(onSubscribePublishMulticast$PublishProducerArray, 0, onSubscribePublishMulticast$PublishProducerArray2, 0, n2);
            onSubscribePublishMulticast$PublishProducerArray2[n2] = onSubscribePublishMulticast$PublishProducer;
            this.subscribers = onSubscribePublishMulticast$PublishProducerArray2;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(OnSubscribePublishMulticast$PublishProducer<T> onSubscribePublishMulticast$PublishProducer) {
        OnSubscribePublishMulticast$PublishProducer<T>[] onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
        if (this.subscribers == TERMINATED || onSubscribePublishMulticast$PublishProducerArray == EMPTY) {
            return;
        }
        OnSubscribePublishMulticast onSubscribePublishMulticast = this;
        synchronized (onSubscribePublishMulticast) {
            OnSubscribePublishMulticast$PublishProducer<?>[] onSubscribePublishMulticast$PublishProducerArray2;
            onSubscribePublishMulticast$PublishProducerArray = this.subscribers;
            if (this.subscribers == TERMINATED || onSubscribePublishMulticast$PublishProducerArray == EMPTY) {
                return;
            }
            int n2 = -1;
            int n3 = onSubscribePublishMulticast$PublishProducerArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (onSubscribePublishMulticast$PublishProducerArray[i2] != onSubscribePublishMulticast$PublishProducer) continue;
                n2 = i2;
                break;
            }
            if (n2 < 0) {
                return;
            }
            if (n3 == 1) {
                onSubscribePublishMulticast$PublishProducerArray2 = EMPTY;
            } else {
                onSubscribePublishMulticast$PublishProducerArray2 = new OnSubscribePublishMulticast$PublishProducer[n3 - 1];
                System.arraycopy(onSubscribePublishMulticast$PublishProducerArray, 0, onSubscribePublishMulticast$PublishProducerArray2, 0, n2);
                System.arraycopy(onSubscribePublishMulticast$PublishProducerArray, n2 + 1, onSubscribePublishMulticast$PublishProducerArray2, n2, n3 - n2 - 1);
            }
            this.subscribers = onSubscribePublishMulticast$PublishProducerArray2;
            return;
        }
    }

    public final Subscriber<T> subscriber() {
        return this.parent;
    }

    @Override
    public final void unsubscribe() {
        this.parent.unsubscribe();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.parent.isUnsubscribed();
    }
}

