/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.MissingBackpressureException;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.ExceptionsUtils;
import com.zoyi.rx.internal.util.RxRingBuffer;
import com.zoyi.rx.internal.util.atomic.SpscAtomicArrayQueue;
import com.zoyi.rx.internal.util.atomic.SpscLinkedArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class OnSubscribeFlattenIterable$FlattenIterableSubscriber<T, R>
extends Subscriber<T> {
    final Subscriber<? super R> actual;
    final Func1<? super T, ? extends Iterable<? extends R>> mapper;
    final long limit;
    final Queue<Object> queue;
    final AtomicReference<Throwable> error;
    final AtomicLong requested;
    final AtomicInteger wip;
    final NotificationLite<T> nl;
    volatile boolean done;
    long produced;
    Iterator<? extends R> active;

    public OnSubscribeFlattenIterable$FlattenIterableSubscriber(Subscriber<? super R> subscriber, Func1<? super T, ? extends Iterable<? extends R>> func1, int n2) {
        this.actual = subscriber;
        this.mapper = func1;
        this.error = new AtomicReference();
        this.wip = new AtomicInteger();
        this.requested = new AtomicLong();
        this.nl = NotificationLite.instance();
        if (n2 == Integer.MAX_VALUE) {
            this.limit = Long.MAX_VALUE;
            this.queue = new SpscLinkedArrayQueue<Object>(RxRingBuffer.SIZE);
        } else {
            this.limit = n2 - (n2 >> 2);
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue<Object>(n2) : new SpscAtomicArrayQueue<Object>(n2);
        }
        this.request(n2);
    }

    @Override
    public final void onNext(T t2) {
        if (!this.queue.offer(this.nl.next(t2))) {
            this.unsubscribe();
            this.onError(new MissingBackpressureException());
            return;
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable throwable) {
        if (ExceptionsUtils.addThrowable(this.error, throwable)) {
            this.done = true;
            this.drain();
            return;
        }
        RxJavaHooks.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        this.done = true;
        this.drain();
    }

    final void requestMore(long l2) {
        if (l2 > 0L) {
            BackpressureUtils.getAndAddRequest(this.requested, l2);
            this.drain();
            return;
        }
        if (l2 < 0L) {
            throw new IllegalStateException("n >= 0 required but it was " + l2);
        }
    }

    final void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        Subscriber<R> subscriber = this.actual;
        Queue<Object> queue = this.queue;
        int n2 = 1;
        while (true) {
            Iterator<R> iterator;
            if ((iterator = this.active) == null) {
                boolean bl;
                boolean bl2 = this.done;
                Object object = queue.poll();
                boolean bl3 = bl = object == null;
                if (this.checkTerminated(bl2, bl, subscriber, queue)) {
                    return;
                }
                if (!bl) {
                    boolean bl4;
                    long l2 = this.produced + 1L;
                    if (l2 == this.limit) {
                        this.produced = 0L;
                        this.request(l2);
                    } else {
                        this.produced = l2;
                    }
                    try {
                        Iterable<R> iterable = this.mapper.call(this.nl.getValue(object));
                        iterator = iterable.iterator();
                        bl4 = iterator.hasNext();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Exceptions.throwIfFatal(throwable);
                        this.onError(throwable2);
                        continue;
                    }
                    if (!bl4) continue;
                    this.active = iterator;
                }
            }
            if (iterator != null) {
                long l3;
                long l4 = this.requested.get();
                for (l3 = 0L; l3 != l4; ++l3) {
                    Object object;
                    if (this.checkTerminated(this.done, false, subscriber, queue)) {
                        return;
                    }
                    try {
                        object = iterator.next();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3 = throwable;
                        Exceptions.throwIfFatal(throwable);
                        iterator = null;
                        this.active = null;
                        this.onError(throwable3);
                        break;
                    }
                    subscriber.onNext(object);
                    if (this.checkTerminated(this.done, false, subscriber, queue)) {
                        return;
                    }
                    try {
                        boolean bl = iterator.hasNext();
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        Exceptions.throwIfFatal(throwable);
                        iterator = null;
                        this.active = null;
                        this.onError((Throwable)object);
                        break;
                    }
                }
                if (l3 == l4 && this.checkTerminated(this.done, queue.isEmpty() && iterator == null, subscriber, queue)) {
                    return;
                }
                if (l3 != 0L) {
                    BackpressureUtils.produced(this.requested, l3);
                }
                if (iterator == null) continue;
            }
            if ((n2 = this.wip.addAndGet(-n2)) == 0) break;
        }
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<?> subscriber, Queue<?> queue) {
        if (subscriber.isUnsubscribed()) {
            queue.clear();
            this.active = null;
            return true;
        }
        if (bl) {
            Throwable throwable = this.error.get();
            if (throwable != null) {
                throwable = ExceptionsUtils.terminate(this.error);
                this.unsubscribe();
                queue.clear();
                this.active = null;
                subscriber.onError(throwable);
                return true;
            }
            if (bl2) {
                subscriber.onCompleted();
                return true;
            }
        }
        return false;
    }
}

