/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.OnSubscribeDetach$TerminatedProducer;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class OnSubscribeDetach$DetachSubscriber<T>
extends Subscriber<T> {
    final AtomicReference<Subscriber<? super T>> actual;
    final AtomicReference<Producer> producer;
    final AtomicLong requested;

    public OnSubscribeDetach$DetachSubscriber(Subscriber<? super T> subscriber) {
        this.actual = new AtomicReference<Subscriber<T>>(subscriber);
        this.producer = new AtomicReference();
        this.requested = new AtomicLong();
    }

    @Override
    public final void onNext(T t2) {
        Subscriber<T> subscriber = this.actual.get();
        if (subscriber != null) {
            subscriber.onNext(t2);
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        this.producer.lazySet(OnSubscribeDetach$TerminatedProducer.INSTANCE);
        Subscriber subscriber = this.actual.getAndSet(null);
        if (subscriber != null) {
            subscriber.onError(throwable);
            return;
        }
        RxJavaHooks.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        this.producer.lazySet(OnSubscribeDetach$TerminatedProducer.INSTANCE);
        Subscriber subscriber = this.actual.getAndSet(null);
        if (subscriber != null) {
            subscriber.onCompleted();
        }
    }

    final void innerRequest(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        Producer producer = this.producer.get();
        if (producer != null) {
            producer.request(l2);
            return;
        }
        BackpressureUtils.getAndAddRequest(this.requested, l2);
        producer = this.producer.get();
        if (producer != null && producer != OnSubscribeDetach$TerminatedProducer.INSTANCE) {
            long l3 = this.requested.getAndSet(0L);
            producer.request(l3);
        }
    }

    @Override
    public final void setProducer(Producer producer) {
        if (this.producer.compareAndSet(null, producer)) {
            long l2 = this.requested.getAndSet(0L);
            producer.request(l2);
            return;
        }
        if (this.producer.get() != OnSubscribeDetach$TerminatedProducer.INSTANCE) {
            throw new IllegalStateException("Producer already set!");
        }
    }

    final void innerUnsubscribe() {
        this.producer.lazySet(OnSubscribeDetach$TerminatedProducer.INSTANCE);
        this.actual.lazySet(null);
        this.unsubscribe();
    }
}

