/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Notification$Kind;
import com.zoyi.rx.Observer;
import com.zoyi.rx.internal.operators.NotificationLite$1;
import com.zoyi.rx.internal.operators.NotificationLite$2;
import com.zoyi.rx.internal.operators.NotificationLite$OnErrorSentinel;

public final class NotificationLite<T> {
    private static final NotificationLite INSTANCE = new NotificationLite();
    private static final Object ON_COMPLETED_SENTINEL = new NotificationLite$1();
    private static final Object ON_NEXT_NULL_SENTINEL = new NotificationLite$2();

    private NotificationLite() {
    }

    public static <T> NotificationLite<T> instance() {
        return INSTANCE;
    }

    public final Object next(T t2) {
        if (t2 == null) {
            return ON_NEXT_NULL_SENTINEL;
        }
        return t2;
    }

    public final Object completed() {
        return ON_COMPLETED_SENTINEL;
    }

    public final Object error(Throwable throwable) {
        return new NotificationLite$OnErrorSentinel(throwable);
    }

    public final boolean accept(Observer<? super T> observer, Object object) {
        if (object == ON_COMPLETED_SENTINEL) {
            observer.onCompleted();
            return true;
        }
        if (object == ON_NEXT_NULL_SENTINEL) {
            observer.onNext(null);
            return false;
        }
        if (object != null) {
            if (object.getClass() == NotificationLite$OnErrorSentinel.class) {
                observer.onError(((NotificationLite$OnErrorSentinel)object).e);
                return true;
            }
            observer.onNext(object);
            return false;
        }
        throw new IllegalArgumentException("The lite notification can not be null");
    }

    public final boolean isCompleted(Object object) {
        return object == ON_COMPLETED_SENTINEL;
    }

    public final boolean isError(Object object) {
        return object instanceof NotificationLite$OnErrorSentinel;
    }

    public final boolean isNull(Object object) {
        return object == ON_NEXT_NULL_SENTINEL;
    }

    public final boolean isNext(Object object) {
        return object != null && !this.isError(object) && !this.isCompleted(object);
    }

    public final Notification$Kind kind(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The lite notification can not be null");
        }
        if (object == ON_COMPLETED_SENTINEL) {
            return Notification$Kind.OnCompleted;
        }
        if (object instanceof NotificationLite$OnErrorSentinel) {
            return Notification$Kind.OnError;
        }
        return Notification$Kind.OnNext;
    }

    public final T getValue(Object object) {
        if (object == ON_NEXT_NULL_SENTINEL) {
            return null;
        }
        return (T)object;
    }

    public final Throwable getError(Object object) {
        return ((NotificationLite$OnErrorSentinel)object).e;
    }
}

