/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.internal.operators.DeferredScalarSubscriber$InnerProducer;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class DeferredScalarSubscriber<T, R>
extends Subscriber<T> {
    protected final Subscriber<? super R> actual;
    protected boolean hasValue;
    protected R value;
    final AtomicInteger state;
    static final int NO_REQUEST_NO_VALUE = 0;
    static final int HAS_REQUEST_NO_VALUE = 1;
    static final int NO_REQUEST_HAS_VALUE = 2;
    static final int HAS_REQUEST_HAS_VALUE = 3;

    public DeferredScalarSubscriber(Subscriber<? super R> subscriber) {
        this.actual = subscriber;
        this.state = new AtomicInteger();
    }

    @Override
    public void onError(Throwable throwable) {
        this.value = null;
        this.actual.onError(throwable);
    }

    @Override
    public void onCompleted() {
        if (this.hasValue) {
            this.complete(this.value);
            return;
        }
        this.complete();
    }

    protected final void complete() {
        this.actual.onCompleted();
    }

    protected final void complete(R r2) {
        Subscriber<R> subscriber = this.actual;
        do {
            int n2;
            if ((n2 = this.state.get()) == 2 || n2 == 3 || subscriber.isUnsubscribed()) {
                return;
            }
            if (n2 == 1) {
                subscriber.onNext(r2);
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onCompleted();
                }
                this.state.lazySet(3);
                return;
            }
            this.value = r2;
        } while (!this.state.compareAndSet(0, 2));
    }

    final void downstreamRequest(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + l2);
        }
        if (l2 != 0L) {
            Subscriber<R> subscriber = this.actual;
            do {
                int n2;
                if ((n2 = this.state.get()) == 1 || n2 == 3 || subscriber.isUnsubscribed()) {
                    return;
                }
                if (n2 != 2) continue;
                if (this.state.compareAndSet(2, 3)) {
                    subscriber.onNext(this.value);
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onCompleted();
                    }
                }
                return;
            } while (!this.state.compareAndSet(0, 1));
            return;
        }
    }

    @Override
    public final void setProducer(Producer producer) {
        producer.request(Long.MAX_VALUE);
    }

    public final void subscribeTo(Observable<? extends T> observable) {
        this.setupDownstream();
        observable.unsafeSubscribe(this);
    }

    final void setupDownstream() {
        Subscriber<R> subscriber = this.actual;
        subscriber.add(this);
        subscriber.setProducer(new DeferredScalarSubscriber$InnerProducer(this));
    }
}

