/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.Completable$OnSubscribe;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeMerge;
import com.zoyi.rx.internal.operators.CompletableOnSubscribeMergeDelayErrorIterable$1;
import com.zoyi.rx.internal.util.unsafe.MpscLinkedQueue;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableOnSubscribeMergeDelayErrorIterable
implements Completable$OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeDelayErrorIterable(Iterable<? extends Completable> iterable) {
        this.sources = iterable;
    }

    @Override
    public final void call(CompletableSubscriber completableSubscriber) {
        Iterator<? extends Completable> iterator;
        Object object = new CompositeSubscription();
        completableSubscriber.onSubscribe((Subscription)object);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable throwable) {
            completableSubscriber.onError(throwable);
            return;
        }
        if (iterator == null) {
            completableSubscriber.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        AtomicInteger atomicInteger = new AtomicInteger(1);
        MpscLinkedQueue<Throwable> mpscLinkedQueue = new MpscLinkedQueue<Throwable>();
        while (true) {
            Completable completable;
            boolean bl;
            if (((CompositeSubscription)object).isUnsubscribed()) {
                return;
            }
            try {
                bl = iterator.hasNext();
            }
            catch (Throwable throwable) {
                mpscLinkedQueue.offer(throwable);
                if (atomicInteger.decrementAndGet() == 0) {
                    if (mpscLinkedQueue.isEmpty()) {
                        completableSubscriber.onCompleted();
                        return;
                    }
                    completableSubscriber.onError(CompletableOnSubscribeMerge.collectErrors(mpscLinkedQueue));
                }
                return;
            }
            if (!bl) break;
            if (((CompositeSubscription)object).isUnsubscribed()) {
                return;
            }
            try {
                completable = iterator.next();
            }
            catch (Throwable throwable) {
                mpscLinkedQueue.offer(throwable);
                if (atomicInteger.decrementAndGet() == 0) {
                    if (mpscLinkedQueue.isEmpty()) {
                        completableSubscriber.onCompleted();
                        return;
                    }
                    completableSubscriber.onError(CompletableOnSubscribeMerge.collectErrors(mpscLinkedQueue));
                }
                return;
            }
            if (((CompositeSubscription)object).isUnsubscribed()) {
                return;
            }
            if (completable == null) {
                object = new NullPointerException("A completable source is null");
                mpscLinkedQueue.offer((Throwable)object);
                if (atomicInteger.decrementAndGet() == 0) {
                    if (mpscLinkedQueue.isEmpty()) {
                        completableSubscriber.onCompleted();
                        return;
                    }
                    completableSubscriber.onError(CompletableOnSubscribeMerge.collectErrors(mpscLinkedQueue));
                }
                return;
            }
            atomicInteger.getAndIncrement();
            completable.unsafeSubscribe(new CompletableOnSubscribeMergeDelayErrorIterable$1(this, (CompositeSubscription)object, mpscLinkedQueue, atomicInteger, completableSubscriber));
        }
        if (atomicInteger.decrementAndGet() == 0) {
            if (mpscLinkedQueue.isEmpty()) {
                completableSubscriber.onCompleted();
                return;
            }
            completableSubscriber.onError(CompletableOnSubscribeMerge.collectErrors(mpscLinkedQueue));
        }
    }
}

