/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.internal.operators.CachedObservable$CacheState;
import com.zoyi.rx.internal.operators.NotificationLite;
import java.util.concurrent.atomic.AtomicLong;

final class CachedObservable$ReplayProducer<T>
extends AtomicLong
implements Producer,
Subscription {
    private static final long serialVersionUID = -2557562030197141021L;
    final Subscriber<? super T> child;
    final CachedObservable$CacheState<T> state;
    Object[] currentBuffer;
    int currentIndexInBuffer;
    int index;
    boolean emitting;
    boolean missed;

    public CachedObservable$ReplayProducer(Subscriber<? super T> subscriber, CachedObservable$CacheState<T> cachedObservable$CacheState) {
        this.child = subscriber;
        this.state = cachedObservable$CacheState;
    }

    @Override
    public final void request(long l2) {
        long l3;
        long l4;
        do {
            if ((l4 = this.get()) < 0L) {
                return;
            }
            l3 = l4 + l2;
            if (l3 >= 0L) continue;
            l3 = Long.MAX_VALUE;
        } while (!this.compareAndSet(l4, l3));
        this.replay();
    }

    public final long produced(long l2) {
        return this.addAndGet(-l2);
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.get() < 0L;
    }

    @Override
    public final void unsubscribe() {
        long l2 = this.get();
        if (l2 >= 0L && (l2 = this.getAndSet(-1L)) >= 0L) {
            this.state.removeProducer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void replay() {
        Object[] objectArray = this;
        // MONITORENTER : this
        if (this.emitting) {
            this.missed = true;
            // MONITOREXIT : objectArray
            return;
        }
        this.emitting = true;
        // MONITOREXIT : objectArray
        boolean bl = false;
        try {
            NotificationLite<? super T> notificationLite = this.state.nl;
            Subscriber<T> subscriber = this.child;
            while (true) {
                Object[] objectArray2;
                long l2;
                if ((l2 = this.get()) < 0L) {
                    return;
                }
                int n2 = this.state.size();
                if (n2 != 0) {
                    objectArray2 = this.currentBuffer;
                    if (this.currentBuffer == null) {
                        this.currentBuffer = objectArray2 = this.state.head();
                    }
                    int n3 = objectArray2.length - 1;
                    int n4 = this.currentIndexInBuffer;
                    if (l2 == 0L) {
                        Object object = objectArray2[n4];
                        if (notificationLite.isCompleted(object)) {
                            subscriber.onCompleted();
                            bl = true;
                            this.unsubscribe();
                            return;
                        }
                        if (notificationLite.isError(object)) {
                            subscriber.onError(notificationLite.getError(object));
                            bl = true;
                            this.unsubscribe();
                            return;
                        }
                    } else if (l2 > 0L) {
                        int n5;
                        int n6 = 0;
                        for (n5 = this.index; n5 < n2 && l2 > 0L; ++n4, ++n5, --l2, ++n6) {
                            if (subscriber.isUnsubscribed()) {
                                return;
                            }
                            if (n4 == n3) {
                                objectArray2 = (Object[])objectArray2[n3];
                                n4 = 0;
                            }
                            Object object = objectArray2[n4];
                            try {
                                if (!notificationLite.accept(subscriber, object)) continue;
                                bl = true;
                                this.unsubscribe();
                                return;
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Exceptions.throwIfFatal(throwable);
                                bl = true;
                                this.unsubscribe();
                                if (notificationLite.isError(object)) return;
                                if (notificationLite.isCompleted(object)) return;
                                subscriber.onError(OnErrorThrowable.addValueAsLastCause(throwable2, notificationLite.getValue(object)));
                                return;
                            }
                        }
                        if (subscriber.isUnsubscribed()) {
                            return;
                        }
                        this.index = n5;
                        this.currentIndexInBuffer = n4;
                        this.currentBuffer = objectArray2;
                        this.produced(n6);
                    }
                }
                objectArray2 = this;
                // MONITORENTER : this
                if (!this.missed) {
                    this.emitting = false;
                    bl = true;
                    // MONITOREXIT : objectArray2
                    return;
                }
                this.missed = false;
                // MONITOREXIT : objectArray2
            }
        }
        catch (Throwable throwable) {
            if (bl) throw throwable;
            Object[] objectArray3 = this;
            // MONITORENTER : this
            this.emitting = false;
            // MONITOREXIT : objectArray3
            throw throwable;
        }
    }
}

