/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.util.RxRingBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class BlockingOperatorToIterator$SubscriberIterator<T>
extends Subscriber<Notification<? extends T>>
implements Iterator<T> {
    static final int LIMIT = 3 * RxRingBuffer.SIZE / 4;
    private final BlockingQueue<Notification<? extends T>> notifications = new LinkedBlockingQueue<Notification<? extends T>>();
    private Notification<? extends T> buf;
    private int received;

    @Override
    public final void onStart() {
        this.request(RxRingBuffer.SIZE);
    }

    @Override
    public final void onCompleted() {
    }

    @Override
    public final void onError(Throwable throwable) {
        this.notifications.offer(Notification.createOnError(throwable));
    }

    @Override
    public final void onNext(Notification<? extends T> notification) {
        this.notifications.offer(notification);
    }

    @Override
    public final boolean hasNext() {
        if (this.buf == null) {
            this.buf = this.take();
            ++this.received;
            if (this.received >= LIMIT) {
                this.request(this.received);
                this.received = 0;
            }
        }
        if (this.buf.isOnError()) {
            throw Exceptions.propagate(this.buf.getThrowable());
        }
        return !this.buf.isOnCompleted();
    }

    @Override
    public final T next() {
        if (this.hasNext()) {
            T t2 = this.buf.getValue();
            this.buf = null;
            return t2;
        }
        throw new NoSuchElementException();
    }

    private Notification<? extends T> take() {
        try {
            Notification notification = (Notification)this.notifications.poll();
            if (notification != null) {
                return notification;
            }
            return this.notifications.take();
        }
        catch (InterruptedException interruptedException) {
            this.unsubscribe();
            throw Exceptions.propagate(interruptedException);
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Read-only iterator");
    }
}

