/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Observable;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BlockingOperatorNext$NextObserver;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class BlockingOperatorNext$NextIterator<T>
implements Iterator<T> {
    private final BlockingOperatorNext$NextObserver<T> observer;
    private final Observable<? extends T> items;
    private T next;
    private boolean hasNext = true;
    private boolean isNextConsumed = true;
    private Throwable error;
    private boolean started;

    BlockingOperatorNext$NextIterator(Observable<? extends T> observable, BlockingOperatorNext$NextObserver<T> blockingOperatorNext$NextObserver) {
        this.items = observable;
        this.observer = blockingOperatorNext$NextObserver;
    }

    @Override
    public final boolean hasNext() {
        if (this.error != null) {
            throw Exceptions.propagate(this.error);
        }
        if (!this.hasNext) {
            return false;
        }
        if (!this.isNextConsumed) {
            return true;
        }
        return this.moveToNext();
    }

    private boolean moveToNext() {
        try {
            Notification<T> notification;
            if (!this.started) {
                this.started = true;
                this.observer.setWaiting(1);
                this.items.materialize().subscribe(this.observer);
            }
            if ((notification = this.observer.takeNext()).isOnNext()) {
                this.isNextConsumed = false;
                this.next = notification.getValue();
                return true;
            }
            this.hasNext = false;
            if (notification.isOnCompleted()) {
                return false;
            }
            if (notification.isOnError()) {
                this.error = notification.getThrowable();
                throw Exceptions.propagate(this.error);
            }
            throw new IllegalStateException("Should not reach here");
        }
        catch (InterruptedException interruptedException) {
            this.observer.unsubscribe();
            Thread.currentThread().interrupt();
            this.error = interruptedException;
            throw Exceptions.propagate(interruptedException);
        }
    }

    @Override
    public final T next() {
        if (this.error != null) {
            throw Exceptions.propagate(this.error);
        }
        if (this.hasNext()) {
            this.isNextConsumed = true;
            return this.next;
        }
        throw new NoSuchElementException("No more elements");
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Read only iterator");
    }
}

