/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

final class BlockingOperatorLatest$LatestObserverIterator<T>
extends Subscriber<Notification<? extends T>>
implements Iterator<T> {
    final Semaphore notify = new Semaphore(0);
    final AtomicReference<Notification<? extends T>> value = new AtomicReference();
    Notification<? extends T> iNotif;

    BlockingOperatorLatest$LatestObserverIterator() {
    }

    @Override
    public final void onNext(Notification<? extends T> notification) {
        boolean bl = this.value.getAndSet(notification) == null;
        if (bl) {
            this.notify.release();
        }
    }

    @Override
    public final void onError(Throwable throwable) {
    }

    @Override
    public final void onCompleted() {
    }

    @Override
    public final boolean hasNext() {
        if (this.iNotif != null && this.iNotif.isOnError()) {
            throw Exceptions.propagate(this.iNotif.getThrowable());
        }
        if (!(this.iNotif != null && this.iNotif.isOnCompleted() || this.iNotif != null)) {
            Notification notification;
            try {
                this.notify.acquire();
            }
            catch (InterruptedException interruptedException) {
                this.unsubscribe();
                Thread.currentThread().interrupt();
                this.iNotif = Notification.createOnError(interruptedException);
                throw Exceptions.propagate(interruptedException);
            }
            this.iNotif = notification = (Notification)this.value.getAndSet(null);
            if (this.iNotif.isOnError()) {
                throw Exceptions.propagate(this.iNotif.getThrowable());
            }
        }
        return !this.iNotif.isOnCompleted();
    }

    @Override
    public final T next() {
        if (this.hasNext() && this.iNotif.isOnNext()) {
            T t2 = this.iNotif.getValue();
            this.iNotif = null;
            return t2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Read-only iterator.");
    }
}

