/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.android.schedulers;

import android.os.Looper;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.android.plugins.RxAndroidPlugins;
import com.zoyi.rx.android.plugins.RxAndroidSchedulersHook;
import com.zoyi.rx.android.schedulers.LooperScheduler;
import com.zoyi.rx.annotations.Experimental;
import java.util.concurrent.atomic.AtomicReference;

public final class AndroidSchedulers {
    private static final AtomicReference<AndroidSchedulers> INSTANCE = new AtomicReference();
    private final Scheduler mainThreadScheduler;

    private static AndroidSchedulers getInstance() {
        AndroidSchedulers androidSchedulers;
        do {
            if ((androidSchedulers = INSTANCE.get()) == null) continue;
            return androidSchedulers;
        } while (!INSTANCE.compareAndSet(null, androidSchedulers = new AndroidSchedulers()));
        return androidSchedulers;
    }

    private AndroidSchedulers() {
        Object object = RxAndroidPlugins.getInstance().getSchedulersHook();
        object = ((RxAndroidSchedulersHook)object).getMainThreadScheduler();
        if (object != null) {
            this.mainThreadScheduler = object;
            return;
        }
        this.mainThreadScheduler = new LooperScheduler(Looper.getMainLooper());
    }

    public static Scheduler mainThread() {
        return AndroidSchedulers.getInstance().mainThreadScheduler;
    }

    public static Scheduler from(Looper looper) {
        if (looper == null) {
            throw new NullPointerException("looper == null");
        }
        return new LooperScheduler(looper);
    }

    @Experimental
    public static void reset() {
        INSTANCE.set(null);
    }
}

