/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.internal.util.SubscriptionList;

public abstract class Subscriber<T>
implements Observer<T>,
Subscription {
    private static final long NOT_SET = Long.MIN_VALUE;
    private final SubscriptionList subscriptions;
    private final Subscriber<?> subscriber;
    private Producer producer;
    private long requested = Long.MIN_VALUE;

    protected Subscriber() {
        this(null, false);
    }

    protected Subscriber(Subscriber<?> subscriber) {
        this(subscriber, true);
    }

    protected Subscriber(Subscriber<?> subscriber, boolean bl) {
        this.subscriber = subscriber;
        this.subscriptions = bl && subscriber != null ? subscriber.subscriptions : new SubscriptionList();
    }

    public final void add(Subscription subscription) {
        this.subscriptions.add(subscription);
    }

    @Override
    public final void unsubscribe() {
        this.subscriptions.unsubscribe();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.subscriptions.isUnsubscribed();
    }

    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void request(long l2) {
        Producer producer;
        if (l2 < 0L) {
            throw new IllegalArgumentException("number requested cannot be negative: " + l2);
        }
        Subscriber subscriber = this;
        synchronized (subscriber) {
            if (this.producer == null) {
                this.addToRequested(l2);
                return;
            }
            producer = this.producer;
        }
        producer.request(l2);
    }

    private void addToRequested(long l2) {
        if (this.requested == Long.MIN_VALUE) {
            this.requested = l2;
            return;
        }
        long l3 = this.requested + l2;
        if (l3 < 0L) {
            this.requested = Long.MAX_VALUE;
            return;
        }
        this.requested = l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(Producer producer) {
        long l2;
        boolean bl = false;
        Subscriber subscriber = this;
        synchronized (subscriber) {
            l2 = this.requested;
            this.producer = producer;
            if (this.subscriber != null && l2 == Long.MIN_VALUE) {
                bl = true;
            }
        }
        if (bl) {
            this.subscriber.setProducer(this.producer);
            return;
        }
        if (l2 == Long.MIN_VALUE) {
            this.producer.request(Long.MAX_VALUE);
            return;
        }
        this.producer.request(l2);
    }
}

