/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx;

import com.zoyi.rx.Notification$Kind;
import com.zoyi.rx.Observer;

public final class Notification<T> {
    private final Notification$Kind kind;
    private final Throwable throwable;
    private final T value;
    private static final Notification<Void> ON_COMPLETED = new Notification<Object>(Notification$Kind.OnCompleted, null, null);

    public static <T> Notification<T> createOnNext(T t2) {
        return new Notification<T>(Notification$Kind.OnNext, t2, null);
    }

    public static <T> Notification<T> createOnError(Throwable throwable) {
        return new Notification<Object>(Notification$Kind.OnError, null, throwable);
    }

    public static <T> Notification<T> createOnCompleted() {
        return ON_COMPLETED;
    }

    @Deprecated
    public static <T> Notification<T> createOnCompleted(Class<T> clazz) {
        return ON_COMPLETED;
    }

    private Notification(Notification$Kind notification$Kind, T t2, Throwable throwable) {
        this.value = t2;
        this.throwable = throwable;
        this.kind = notification$Kind;
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }

    public final T getValue() {
        return this.value;
    }

    public final boolean hasValue() {
        return this.isOnNext() && this.value != null;
    }

    public final boolean hasThrowable() {
        return this.isOnError() && this.throwable != null;
    }

    public final Notification$Kind getKind() {
        return this.kind;
    }

    public final boolean isOnError() {
        return this.getKind() == Notification$Kind.OnError;
    }

    public final boolean isOnCompleted() {
        return this.getKind() == Notification$Kind.OnCompleted;
    }

    public final boolean isOnNext() {
        return this.getKind() == Notification$Kind.OnNext;
    }

    public final void accept(Observer<? super T> observer) {
        if (this.kind == Notification$Kind.OnNext) {
            observer.onNext(this.getValue());
            return;
        }
        if (this.kind == Notification$Kind.OnCompleted) {
            observer.onCompleted();
            return;
        }
        observer.onError(this.getThrowable());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64).append('[').append(super.toString()).append(' ').append((Object)this.getKind());
        if (this.hasValue()) {
            stringBuilder.append(' ').append(this.getValue());
        }
        if (this.hasThrowable()) {
            stringBuilder.append(' ').append(this.getThrowable().getMessage());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        int n2 = this.getKind().hashCode();
        if (this.hasValue()) {
            n2 = n2 * 31 + this.getValue().hashCode();
        }
        if (this.hasThrowable()) {
            n2 = n2 * 31 + this.getThrowable().hashCode();
        }
        return n2;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (((Notification)(object = (Notification)object)).getKind() != this.getKind()) {
            return false;
        }
        if (!(this.value == ((Notification)object).value || this.value != null && this.value.equals(((Notification)object).value))) {
            return false;
        }
        return this.throwable == ((Notification)object).throwable || this.throwable != null && this.throwable.equals(((Notification)object).throwable);
    }
}

