/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okio;

import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.ForwardingSink;
import com.zoyi.retrofit2.okio.Segment;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Util;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingSink
extends ForwardingSink {
    private final MessageDigest messageDigest;

    public static HashingSink md5(Sink sink) {
        return new HashingSink(sink, "MD5");
    }

    public static HashingSink sha1(Sink sink) {
        return new HashingSink(sink, "SHA-1");
    }

    public static HashingSink sha256(Sink sink) {
        return new HashingSink(sink, "SHA-256");
    }

    private HashingSink(Sink sink, String string) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    @Override
    public final void write(Buffer buffer, long l2) throws IOException {
        int n2;
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        Segment segment = buffer.head;
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min(l2 - i2, (long)(segment.limit - segment.pos));
            this.messageDigest.update(segment.data, segment.pos, n2);
            segment = segment.next;
        }
        super.write(buffer, l2);
    }

    public final ByteString hash() {
        byte[] byArray = this.messageDigest.digest();
        return ByteString.of(byArray);
    }
}

