/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.logging;

import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Interceptor;
import com.zoyi.retrofit2.okhttp3.Interceptor$Chain;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine;
import com.zoyi.retrofit2.okhttp3.logging.HttpLoggingInterceptor$Level;
import com.zoyi.retrofit2.okhttp3.logging.HttpLoggingInterceptor$Logger;
import com.zoyi.retrofit2.okio.Buffer;
import com.zoyi.retrofit2.okio.BufferedSource;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.TimeUnit;

public final class HttpLoggingInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final HttpLoggingInterceptor$Logger logger;
    private volatile HttpLoggingInterceptor$Level level = HttpLoggingInterceptor$Level.NONE;

    public HttpLoggingInterceptor() {
        this(HttpLoggingInterceptor$Logger.DEFAULT);
    }

    public HttpLoggingInterceptor(HttpLoggingInterceptor$Logger httpLoggingInterceptor$Logger) {
        this.logger = httpLoggingInterceptor$Logger;
    }

    public final HttpLoggingInterceptor setLevel(HttpLoggingInterceptor$Level httpLoggingInterceptor$Level) {
        if (httpLoggingInterceptor$Level == null) {
            throw new NullPointerException("level == null. Use Level.NONE instead.");
        }
        this.level = httpLoggingInterceptor$Level;
        return this;
    }

    public final HttpLoggingInterceptor$Level getLevel() {
        return this.level;
    }

    @Override
    public final Response intercept(Interceptor$Chain object) throws IOException {
        Response response;
        HttpLoggingInterceptor$Level httpLoggingInterceptor$Level = this.level;
        Object object2 = object.request();
        if (httpLoggingInterceptor$Level == HttpLoggingInterceptor$Level.NONE) {
            return object.proceed((Request)object2);
        }
        boolean bl = httpLoggingInterceptor$Level == HttpLoggingInterceptor$Level.BODY;
        boolean bl2 = bl || httpLoggingInterceptor$Level == HttpLoggingInterceptor$Level.HEADERS;
        RequestBody requestBody = ((Request)object2).body();
        boolean bl3 = requestBody != null;
        Object object3 = object.connection();
        object3 = object3 != null ? object3.protocol() : Protocol.HTTP_1_1;
        object3 = "--> " + ((Request)object2).method() + ' ' + ((Request)object2).url() + ' ' + object3;
        if (!bl2 && bl3) {
            object3 = (String)object3 + " (" + requestBody.contentLength() + "-byte body)";
        }
        this.logger.log((String)object3);
        if (bl2) {
            Object object4;
            if (bl3) {
                if (requestBody.contentType() != null) {
                    this.logger.log("Content-Type: " + requestBody.contentType());
                }
                if (requestBody.contentLength() != -1L) {
                    this.logger.log("Content-Length: " + requestBody.contentLength());
                }
            }
            Headers headers = ((Request)object2).headers();
            int n2 = headers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object4 = headers.name(i2);
                if ("Content-Type".equalsIgnoreCase((String)object4) || "Content-Length".equalsIgnoreCase((String)object4)) continue;
                this.logger.log((String)object4 + ": " + headers.value(i2));
            }
            if (!bl || !bl3) {
                this.logger.log("--> END " + ((Request)object2).method());
            } else if (this.bodyEncoded(((Request)object2).headers())) {
                this.logger.log("--> END " + ((Request)object2).method() + " (encoded body omitted)");
            } else {
                Buffer buffer = new Buffer();
                requestBody.writeTo(buffer);
                Charset charset = UTF8;
                object4 = requestBody.contentType();
                if (object4 != null) {
                    charset = ((MediaType)object4).charset(UTF8);
                }
                this.logger.log("");
                if (HttpLoggingInterceptor.isPlaintext(buffer)) {
                    this.logger.log(buffer.readString(charset));
                    this.logger.log("--> END " + ((Request)object2).method() + " (" + requestBody.contentLength() + "-byte body)");
                } else {
                    this.logger.log("--> END " + ((Request)object2).method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                }
            }
        }
        long l2 = System.nanoTime();
        try {
            response = object.proceed((Request)object2);
        }
        catch (Exception exception) {
            this.logger.log("<-- HTTP FAILED: " + exception);
            throw exception;
        }
        long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
        object = response.body();
        long l4 = ((ResponseBody)object).contentLength();
        object2 = l4 != -1L ? l4 + "-byte" : "unknown-length";
        this.logger.log("<-- " + response.code() + ' ' + response.message() + ' ' + response.request().url() + " (" + l3 + "ms" + (!bl2 ? ", " + (String)object2 + " body" : "") + ')');
        if (bl2) {
            Object object5 = response.headers();
            int n3 = ((Headers)object5).size();
            for (int i3 = 0; i3 < n3; ++i3) {
                this.logger.log(((Headers)object5).name(i3) + ": " + ((Headers)object5).value(i3));
            }
            if (!bl || !HttpEngine.hasBody(response)) {
                this.logger.log("<-- END HTTP");
            } else if (this.bodyEncoded(response.headers())) {
                this.logger.log("<-- END HTTP (encoded body omitted)");
            } else {
                BufferedSource bufferedSource = ((ResponseBody)object).source();
                bufferedSource.request(Long.MAX_VALUE);
                Buffer buffer = bufferedSource.buffer();
                object5 = UTF8;
                object = ((ResponseBody)object).contentType();
                if (object != null) {
                    try {
                        object5 = ((MediaType)object).charset(UTF8);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        this.logger.log("");
                        this.logger.log("Couldn't decode the response body; charset is likely malformed.");
                        this.logger.log("<-- END HTTP");
                        return response;
                    }
                }
                if (!HttpLoggingInterceptor.isPlaintext(buffer)) {
                    this.logger.log("");
                    this.logger.log("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                    return response;
                }
                if (l4 != 0L) {
                    this.logger.log("");
                    this.logger.log(buffer.clone().readString((Charset)object5));
                }
                this.logger.log("<-- END HTTP (" + buffer.size() + "-byte body)");
            }
        }
        return response;
    }

    static boolean isPlaintext(Buffer buffer) throws EOFException {
        try {
            Buffer buffer2 = new Buffer();
            long l2 = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(buffer2, 0L, l2);
            for (int i2 = 0; i2 < 16 && !buffer2.exhausted(); ++i2) {
                int n2 = buffer2.readUtf8CodePoint();
                if (!Character.isISOControl(n2) || Character.isWhitespace(n2)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    private boolean bodyEncoded(Headers object) {
        return (object = ((Headers)object).get("Content-Encoding")) != null && !((String)object).equalsIgnoreCase("identity");
    }
}

