/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.io;

import com.zoyi.retrofit2.okhttp3.internal.io.FileSystem;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Source;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

final class FileSystem$1
implements FileSystem {
    FileSystem$1() {
    }

    @Override
    public final Source source(File file) throws FileNotFoundException {
        return Okio.source(file);
    }

    @Override
    public final Sink sink(File file) throws FileNotFoundException {
        try {
            return Okio.sink(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            file.getParentFile().mkdirs();
            return Okio.sink(file);
        }
    }

    @Override
    public final Sink appendingSink(File file) throws FileNotFoundException {
        try {
            return Okio.appendingSink(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            file.getParentFile().mkdirs();
            return Okio.appendingSink(file);
        }
    }

    @Override
    public final void delete(File file) throws IOException {
        if (!file.delete() && file.exists()) {
            throw new IOException("failed to delete " + file);
        }
    }

    @Override
    public final boolean exists(File file) {
        return file.exists();
    }

    @Override
    public final long size(File file) {
        return file.length();
    }

    @Override
    public final void rename(File file, File file2) throws IOException {
        this.delete(file2);
        if (!file.renameTo(file2)) {
            throw new IOException("failed to rename " + file + " to " + file2);
        }
    }

    @Override
    public final void deleteContents(File fileArray) throws IOException {
        File[] fileArray2 = fileArray.listFiles();
        if (fileArray2 == null) {
            throw new IOException("not a readable directory: " + fileArray);
        }
        fileArray = fileArray2;
        int n2 = fileArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = fileArray[i2];
            if (file.isDirectory()) {
                this.deleteContents(file);
            }
            if (file.delete()) continue;
            throw new IOException("failed to delete " + file);
        }
    }
}

