/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.Address;
import com.zoyi.retrofit2.okhttp3.ConnectionPool;
import com.zoyi.retrofit2.okhttp3.Route;
import com.zoyi.retrofit2.okhttp3.internal.Internal;
import com.zoyi.retrofit2.okhttp3.internal.RouteDatabase;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.StreamResetException;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream;
import com.zoyi.retrofit2.okhttp3.internal.http.Http2xStream;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpStream;
import com.zoyi.retrofit2.okhttp3.internal.http.RouteException;
import com.zoyi.retrofit2.okhttp3.internal.http.RouteSelector;
import com.zoyi.retrofit2.okhttp3.internal.io.RealConnection;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public final class StreamAllocation {
    public final Address address;
    private Route route;
    private final ConnectionPool connectionPool;
    private final RouteSelector routeSelector;
    private int refusedStreamCount;
    private RealConnection connection;
    private boolean released;
    private boolean canceled;
    private HttpStream stream;

    public StreamAllocation(ConnectionPool connectionPool, Address address) {
        this.connectionPool = connectionPool;
        this.address = address;
        this.routeSelector = new RouteSelector(address, this.routeDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpStream newStream(int n2, int n3, int n4, boolean bl, boolean bl2) throws RouteException, IOException {
        try {
            Object object = this.findHealthyConnection(n2, n3, n4, bl, bl2);
            if (((RealConnection)object).framedConnection != null) {
                object = new Http2xStream(this, ((RealConnection)object).framedConnection);
            } else {
                ((RealConnection)object).socket().setSoTimeout(n3);
                ((RealConnection)object).source.timeout().timeout(n3, TimeUnit.MILLISECONDS);
                ((RealConnection)object).sink.timeout().timeout(n4, TimeUnit.MILLISECONDS);
                object = new Http1xStream(this, ((RealConnection)object).source, ((RealConnection)object).sink);
            }
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                this.stream = object;
                return object;
            }
        }
        catch (IOException iOException) {
            throw new RouteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int n2, int n3, int n4, boolean bl, boolean bl2) throws IOException, RouteException {
        RealConnection realConnection;
        while (true) {
            realConnection = this.findConnection(n2, n3, n4, bl);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (realConnection.successCount == 0) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(bl2)) break;
            this.noNewStreams();
        }
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int n2, int n3, int n4, boolean bl) throws IOException, RouteException {
        Object object;
        Object object2 = this.connectionPool;
        synchronized (object2) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.stream != null) {
                throw new IllegalStateException("stream != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            object = this.connection;
            if (object != null && !((RealConnection)object).noNewStreams) {
                return object;
            }
            object = Internal.instance.get(this.connectionPool, this.address, this);
            if (object != null) {
                this.connection = object;
                return object;
            }
            object = this.route;
        }
        if (object == null) {
            object = this.routeSelector.next();
            object2 = this.connectionPool;
            synchronized (object2) {
                this.route = object;
                this.refusedStreamCount = 0;
            }
        }
        object2 = new RealConnection((Route)object);
        this.acquire((RealConnection)object2);
        object = this.connectionPool;
        synchronized (object) {
            Internal.instance.put(this.connectionPool, (RealConnection)object2);
            this.connection = object2;
            if (this.canceled) {
                throw new IOException("Canceled");
            }
        }
        ((RealConnection)object2).connect(n2, n3, n4, this.address.connectionSpecs(), bl);
        this.routeDatabase().connected(((RealConnection)object2).route());
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamFinished(boolean bl, HttpStream httpStream) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (httpStream == null || httpStream != this.stream) {
                throw new IllegalStateException("expected " + this.stream + " but was " + httpStream);
            }
            if (!bl) {
                ++this.connection.successCount;
            }
        }
        this.deallocate(bl, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpStream stream() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.stream;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public final synchronized RealConnection connection() {
        return this.connection;
    }

    public final void release() {
        this.deallocate(false, true, false);
    }

    public final void noNewStreams() {
        this.deallocate(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate(boolean bl, boolean bl2, boolean bl3) {
        RealConnection realConnection = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (bl3) {
                this.stream = null;
            }
            if (bl2) {
                this.released = true;
            }
            if (this.connection != null) {
                if (bl) {
                    this.connection.noNewStreams = true;
                }
                if (this.stream == null && (this.released || this.connection.noNewStreams)) {
                    this.release(this.connection);
                    if (this.connection.allocations.isEmpty()) {
                        this.connection.idleAtNanos = System.nanoTime();
                        if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                            realConnection = this.connection;
                        }
                    }
                    this.connection = null;
                }
            }
        }
        if (realConnection != null) {
            Util.closeQuietly(realConnection.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        RealConnection realConnection;
        HttpStream httpStream;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            httpStream = this.stream;
            realConnection = this.connection;
        }
        if (httpStream != null) {
            httpStream.cancel();
            return;
        }
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamFailed(IOException iOException) {
        boolean bl = false;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (iOException instanceof StreamResetException) {
                iOException = (StreamResetException)iOException;
                if (((StreamResetException)iOException).errorCode == ErrorCode.REFUSED_STREAM) {
                    ++this.refusedStreamCount;
                }
                if (((StreamResetException)iOException).errorCode != ErrorCode.REFUSED_STREAM || this.refusedStreamCount > 1) {
                    bl = true;
                    this.route = null;
                }
            } else if (this.connection != null && !this.connection.isMultiplexed()) {
                bl = true;
                if (this.connection.successCount == 0) {
                    if (this.route != null && iOException != null) {
                        this.routeSelector.connectFailed(this.route, iOException);
                    }
                    this.route = null;
                }
            }
        }
        this.deallocate(bl, false, true);
    }

    public final void acquire(RealConnection realConnection) {
        realConnection.allocations.add(new WeakReference<StreamAllocation>(this));
    }

    private void release(RealConnection realConnection) {
        int n2 = realConnection.allocations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Reference<StreamAllocation> reference = realConnection.allocations.get(i2);
            if (reference.get() != this) continue;
            realConnection.allocations.remove(i2);
            return;
        }
        throw new IllegalStateException();
    }

    public final boolean hasMoreRoutes() {
        return this.route != null || this.routeSelector.hasNext();
    }

    public final String toString() {
        return this.address.toString();
    }
}

