/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.Response$Builder;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.Internal;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedStream;
import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.http.Http2xStream$StreamFinishingSource;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpStream;
import com.zoyi.retrofit2.okhttp3.internal.http.RealResponseBody;
import com.zoyi.retrofit2.okhttp3.internal.http.RequestLine;
import com.zoyi.retrofit2.okhttp3.internal.http.RetryableSink;
import com.zoyi.retrofit2.okhttp3.internal.http.StatusLine;
import com.zoyi.retrofit2.okhttp3.internal.http.StreamAllocation;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.Okio;
import com.zoyi.retrofit2.okio.Sink;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2xStream
implements HttpStream {
    private static final ByteString CONNECTION = ByteString.encodeUtf8("connection");
    private static final ByteString HOST = ByteString.encodeUtf8("host");
    private static final ByteString KEEP_ALIVE = ByteString.encodeUtf8("keep-alive");
    private static final ByteString PROXY_CONNECTION = ByteString.encodeUtf8("proxy-connection");
    private static final ByteString TRANSFER_ENCODING = ByteString.encodeUtf8("transfer-encoding");
    private static final ByteString TE = ByteString.encodeUtf8("te");
    private static final ByteString ENCODING = ByteString.encodeUtf8("encoding");
    private static final ByteString UPGRADE = ByteString.encodeUtf8("upgrade");
    private static final List<ByteString> SPDY_3_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TRANSFER_ENCODING, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY, Header.TARGET_HOST, Header.VERSION);
    private static final List<ByteString> SPDY_3_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TRANSFER_ENCODING);
    private static final List<ByteString> HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE, Header.TARGET_METHOD, Header.TARGET_PATH, Header.TARGET_SCHEME, Header.TARGET_AUTHORITY, Header.TARGET_HOST, Header.VERSION);
    private static final List<ByteString> HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableList(CONNECTION, HOST, KEEP_ALIVE, PROXY_CONNECTION, TE, TRANSFER_ENCODING, ENCODING, UPGRADE);
    private final StreamAllocation streamAllocation;
    private final FramedConnection framedConnection;
    private HttpEngine httpEngine;
    private FramedStream stream;

    public Http2xStream(StreamAllocation streamAllocation, FramedConnection framedConnection) {
        this.streamAllocation = streamAllocation;
        this.framedConnection = framedConnection;
    }

    @Override
    public final void setHttpEngine(HttpEngine httpEngine) {
        this.httpEngine = httpEngine;
    }

    @Override
    public final Sink createRequestBody(Request request, long l2) throws IOException {
        return this.stream.getSink();
    }

    @Override
    public final void writeRequestHeaders(Request object) throws IOException {
        if (this.stream != null) {
            return;
        }
        this.httpEngine.writingRequestHeaders();
        boolean bl = this.httpEngine.permitsRequestBody((Request)object);
        object = this.framedConnection.getProtocol() == Protocol.HTTP_2 ? Http2xStream.http2HeadersList((Request)object) : Http2xStream.spdy3HeadersList((Request)object);
        this.stream = this.framedConnection.newStream((List<Header>)object, bl, true);
        this.stream.readTimeout().timeout(this.httpEngine.client.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout(this.httpEngine.client.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void writeRequestBody(RetryableSink retryableSink) throws IOException {
        retryableSink.writeToSocket(this.stream.getSink());
    }

    @Override
    public final void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public final Response$Builder readResponseHeaders() throws IOException {
        if (this.framedConnection.getProtocol() == Protocol.HTTP_2) {
            return Http2xStream.readHttp2HeadersList(this.stream.getResponseHeaders());
        }
        return Http2xStream.readSpdy3HeadersList(this.stream.getResponseHeaders());
    }

    public static List<Header> spdy3HeadersList(Request object) {
        Headers headers = ((Request)object).headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 5);
        arrayList.add(new Header(Header.TARGET_METHOD, ((Request)object).method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(((Request)object).url())));
        arrayList.add(new Header(Header.VERSION, "HTTP/1.1"));
        arrayList.add(new Header(Header.TARGET_HOST, Util.hostHeader(((Request)object).url(), false)));
        arrayList.add(new Header(Header.TARGET_SCHEME, ((Request)object).url().scheme()));
        object = new LinkedHashSet();
        int n2 = headers.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (SPDY_3_SKIPPED_REQUEST_HEADERS.contains(byteString)) continue;
            String string = headers.value(i2);
            if (object.add(byteString)) {
                arrayList.add(new Header(byteString, string));
                continue;
            }
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                if (!((Header)arrayList.get((int)i3)).name.equals(byteString)) continue;
                string = Http2xStream.joinOnNull(((Header)arrayList.get((int)i3)).value.utf8(), string);
                arrayList.set(i3, new Header(byteString, string));
                continue block0;
            }
        }
        return arrayList;
    }

    private static String joinOnNull(String string, String string2) {
        return string + '\u0000' + string2;
    }

    public static List<Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        arrayList.add(new Header(Header.TARGET_AUTHORITY, Util.hostHeader(request.url(), false)));
        arrayList.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = ByteString.encodeUtf8(headers.name(i2).toLowerCase(Locale.US));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(byteString)) continue;
            arrayList.add(new Header(byteString, headers.value(i2)));
        }
        return arrayList;
    }

    public static Response$Builder readSpdy3HeadersList(List<Header> list) throws IOException {
        String string = null;
        String string2 = "HTTP/1.1";
        Headers$Builder headers$Builder = new Headers$Builder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = list.get((int)i2).name;
            String string3 = list.get((int)i2).value.utf8();
            int n3 = 0;
            while (n3 < string3.length()) {
                int n4 = string3.indexOf(0, n3);
                if (n4 == -1) {
                    n4 = string3.length();
                }
                String string4 = string3.substring(n3, n4);
                if (byteString.equals(Header.RESPONSE_STATUS)) {
                    string = string4;
                } else if (byteString.equals(Header.VERSION)) {
                    string2 = string4;
                } else if (!SPDY_3_SKIPPED_RESPONSE_HEADERS.contains(byteString)) {
                    Internal.instance.addLenient(headers$Builder, byteString.utf8(), string4);
                }
                n3 = n4 + 1;
            }
        }
        if (string == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        StatusLine statusLine = StatusLine.parse(string2 + " " + string);
        return new Response$Builder().protocol(Protocol.SPDY_3).code(statusLine.code).message(statusLine.message).headers(headers$Builder.build());
    }

    public static Response$Builder readHttp2HeadersList(List<Header> list) throws IOException {
        String string = null;
        Headers$Builder headers$Builder = new Headers$Builder();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = list.get((int)i2).name;
            String string2 = list.get((int)i2).value.utf8();
            if (byteString.equals(Header.RESPONSE_STATUS)) {
                string = string2;
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(byteString)) continue;
            Internal.instance.addLenient(headers$Builder, byteString.utf8(), string2);
        }
        if (string == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        StatusLine statusLine = StatusLine.parse("HTTP/1.1 " + string);
        return new Response$Builder().protocol(Protocol.HTTP_2).code(statusLine.code).message(statusLine.message).headers(headers$Builder.build());
    }

    @Override
    public final ResponseBody openResponseBody(Response response) throws IOException {
        Http2xStream$StreamFinishingSource http2xStream$StreamFinishingSource = new Http2xStream$StreamFinishingSource(this, this.stream.getSource());
        return new RealResponseBody(response.headers(), Okio.buffer(http2xStream$StreamFinishingSource));
    }

    @Override
    public final void cancel() {
        if (this.stream != null) {
            this.stream.closeLater(ErrorCode.CANCEL);
        }
    }

    static /* synthetic */ StreamAllocation access$000(Http2xStream http2xStream) {
        return http2xStream.streamAllocation;
    }
}

