/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.http;

import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream;
import com.zoyi.retrofit2.okhttp3.internal.http.Http1xStream$AbstractSource;
import com.zoyi.retrofit2.okhttp3.internal.http.HttpEngine;
import com.zoyi.retrofit2.okio.Buffer;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

class Http1xStream$ChunkedSource
extends Http1xStream$AbstractSource {
    private static final long NO_CHUNK_YET = -1L;
    private long bytesRemainingInChunk;
    private boolean hasMoreChunks;
    private final HttpEngine httpEngine;
    final /* synthetic */ Http1xStream this$0;

    Http1xStream$ChunkedSource(Http1xStream http1xStream, HttpEngine httpEngine) throws IOException {
        this.this$0 = http1xStream;
        super(http1xStream, null);
        this.bytesRemainingInChunk = -1L;
        this.hasMoreChunks = true;
        this.httpEngine = httpEngine;
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (!this.hasMoreChunks) {
            return -1L;
        }
        if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
            this.readChunkSize();
            if (!this.hasMoreChunks) {
                return -1L;
            }
        }
        if ((l3 = Http1xStream.access$600(this.this$0).read(buffer, Math.min(l2, this.bytesRemainingInChunk))) == -1L) {
            this.endOfInput(false);
            throw new ProtocolException("unexpected end of stream");
        }
        this.bytesRemainingInChunk -= l3;
        return l3;
    }

    private void readChunkSize() throws IOException {
        if (this.bytesRemainingInChunk != -1L) {
            Http1xStream.access$600(this.this$0).readUtf8LineStrict();
        }
        try {
            this.bytesRemainingInChunk = Http1xStream.access$600(this.this$0).readHexadecimalUnsignedLong();
            String string = Http1xStream.access$600(this.this$0).readUtf8LineStrict().trim();
            if (this.bytesRemainingInChunk < 0L || !string.isEmpty() && !string.startsWith(";")) {
                throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + string + "\"");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException(numberFormatException.getMessage());
        }
        if (this.bytesRemainingInChunk == 0L) {
            this.hasMoreChunks = false;
            this.httpEngine.receiveHeaders(this.this$0.readHeaders());
            this.endOfInput(true);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
            this.endOfInput(false);
        }
        this.closed = true;
    }
}

