/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import java.util.Arrays;

public final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65536;
    static final int FLAG_CLEAR_PREVIOUSLY_PERSISTED_SETTINGS = 1;
    static final int PERSIST_VALUE = 1;
    static final int PERSISTED = 2;
    static final int UPLOAD_BANDWIDTH = 1;
    static final int HEADER_TABLE_SIZE = 1;
    static final int DOWNLOAD_BANDWIDTH = 2;
    static final int ENABLE_PUSH = 2;
    static final int ROUND_TRIP_TIME = 3;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int CURRENT_CWND = 5;
    static final int MAX_FRAME_SIZE = 5;
    static final int DOWNLOAD_RETRANS_RATE = 6;
    static final int MAX_HEADER_LIST_SIZE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int CLIENT_CERTIFICATE_VECTOR_SIZE = 8;
    static final int FLOW_CONTROL_OPTIONS = 10;
    static final int COUNT = 10;
    static final int FLOW_CONTROL_OPTIONS_DISABLED = 1;
    private int set;
    private int persistValue;
    private int persisted;
    private final int[] values = new int[10];

    final void clear() {
        this.persisted = 0;
        this.persistValue = 0;
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    final Settings set(int n2, int n3, int n4) {
        if (n2 >= this.values.length) {
            return this;
        }
        int n5 = 1 << n2;
        this.set |= n5;
        this.persistValue = (n3 & 1) != 0 ? (this.persistValue |= n5) : (this.persistValue &= ~n5);
        this.persisted = (n3 & 2) != 0 ? (this.persisted |= n5) : (this.persisted &= ~n5);
        this.values[n2] = n4;
        return this;
    }

    final boolean isSet(int n2) {
        return (this.set & (n2 = 1 << n2)) != 0;
    }

    final int get(int n2) {
        return this.values[n2];
    }

    final int flags(int n2) {
        int n3 = 0;
        if (this.isPersisted(n2)) {
            n3 = 2;
        }
        if (this.persistValue(n2)) {
            n3 |= 1;
        }
        return n3;
    }

    final int size() {
        return Integer.bitCount(this.set);
    }

    final int getUploadBandwidth(int n2) {
        if ((2 & this.set) != 0) {
            return this.values[1];
        }
        return n2;
    }

    final int getHeaderTableSize() {
        if ((2 & this.set) != 0) {
            return this.values[1];
        }
        return -1;
    }

    final int getDownloadBandwidth(int n2) {
        if ((4 & this.set) != 0) {
            return this.values[2];
        }
        return n2;
    }

    final boolean getEnablePush(boolean bl) {
        return ((4 & this.set) != 0 ? this.values[2] : (bl ? 1 : 0)) == 1;
    }

    final int getRoundTripTime(int n2) {
        if ((8 & this.set) != 0) {
            return this.values[3];
        }
        return n2;
    }

    final int getMaxConcurrentStreams(int n2) {
        if ((0x10 & this.set) != 0) {
            return this.values[4];
        }
        return n2;
    }

    final int getCurrentCwnd(int n2) {
        if ((0x20 & this.set) != 0) {
            return this.values[5];
        }
        return n2;
    }

    final int getMaxFrameSize(int n2) {
        if ((0x20 & this.set) != 0) {
            return this.values[5];
        }
        return n2;
    }

    final int getDownloadRetransRate(int n2) {
        if ((0x40 & this.set) != 0) {
            return this.values[6];
        }
        return n2;
    }

    final int getMaxHeaderListSize(int n2) {
        if ((0x40 & this.set) != 0) {
            return this.values[6];
        }
        return n2;
    }

    final int getInitialWindowSize(int n2) {
        if ((0x80 & this.set) != 0) {
            return this.values[7];
        }
        return n2;
    }

    final int getClientCertificateVectorSize(int n2) {
        if ((0x100 & this.set) != 0) {
            return this.values[8];
        }
        return n2;
    }

    final boolean isFlowControlDisabled() {
        int n2 = (0x400 & this.set) != 0 ? this.values[10] : 0;
        return (n2 & 1) != 0;
    }

    final boolean persistValue(int n2) {
        return (this.persistValue & (n2 = 1 << n2)) != 0;
    }

    final boolean isPersisted(int n2) {
        return (this.persisted & (n2 = 1 << n2)) != 0;
    }

    final void merge(Settings settings) {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!settings.isSet(i2)) continue;
            this.set(i2, settings.flags(i2), settings.get(i2));
        }
    }
}

