/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.framed.NameValueBlockReader$1;
import com.zoyi.retrofit2.okhttp3.internal.framed.NameValueBlockReader$2;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.ByteString;
import com.zoyi.retrofit2.okio.InflaterSource;
import com.zoyi.retrofit2.okio.Okio;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Inflater;

class NameValueBlockReader {
    private final InflaterSource inflaterSource;
    private int compressedLimit;
    private final BufferedSource source;

    public NameValueBlockReader(BufferedSource source) {
        source = new NameValueBlockReader$1(this, source);
        NameValueBlockReader$2 nameValueBlockReader$2 = new NameValueBlockReader$2(this);
        this.inflaterSource = new InflaterSource(source, (Inflater)nameValueBlockReader$2);
        this.source = Okio.buffer(this.inflaterSource);
    }

    public List<Header> readNameValueBlock(int n2) throws IOException {
        this.compressedLimit += n2;
        n2 = this.source.readInt();
        if (n2 < 0) {
            throw new IOException("numberOfPairs < 0: " + n2);
        }
        if (n2 > 1024) {
            throw new IOException("numberOfPairs > 1024: " + n2);
        }
        ArrayList<Header> arrayList = new ArrayList<Header>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteString byteString = this.readByteString().toAsciiLowercase();
            ByteString byteString2 = this.readByteString();
            if (byteString.size() == 0) {
                throw new IOException("name.size == 0");
            }
            arrayList.add(new Header(byteString, byteString2));
        }
        this.doneReading();
        return arrayList;
    }

    private ByteString readByteString() throws IOException {
        int n2 = this.source.readInt();
        return this.source.readByteString(n2);
    }

    private void doneReading() throws IOException {
        if (this.compressedLimit > 0) {
            this.inflaterSource.refill();
            if (this.compressedLimit != 0) {
                throw new IOException("compressedLimit > 0: " + this.compressedLimit);
            }
        }
    }

    public void close() throws IOException {
        this.source.close();
    }

    static /* synthetic */ int access$000(NameValueBlockReader nameValueBlockReader) {
        return nameValueBlockReader.compressedLimit;
    }

    static /* synthetic */ int access$002(NameValueBlockReader nameValueBlockReader, int n2) {
        nameValueBlockReader.compressedLimit = n2;
        return nameValueBlockReader.compressedLimit;
    }
}

