/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3.internal.framed;

import com.zoyi.retrofit2.okhttp3.internal.framed.ErrorCode;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedConnection;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedStream$FramedDataSink;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedStream$FramedDataSource;
import com.zoyi.retrofit2.okhttp3.internal.framed.FramedStream$StreamTimeout;
import com.zoyi.retrofit2.okhttp3.internal.framed.Header;
import com.zoyi.retrofit2.okhttp3.internal.framed.HeadersMode;
import com.zoyi.retrofit2.okhttp3.internal.framed.StreamResetException;
import com.zoyi.retrofit2.okio.BufferedSource;
import com.zoyi.retrofit2.okio.Sink;
import com.zoyi.retrofit2.okio.Source;
import com.zoyi.retrofit2.okio.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;

public final class FramedStream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    private final int id;
    private final FramedConnection connection;
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    private final FramedStream$FramedDataSource source;
    final FramedStream$FramedDataSink sink;
    private final FramedStream$StreamTimeout readTimeout = new FramedStream$StreamTimeout(this);
    private final FramedStream$StreamTimeout writeTimeout = new FramedStream$StreamTimeout(this);
    private ErrorCode errorCode = null;

    FramedStream(int n2, FramedConnection framedConnection, boolean bl, boolean bl2, List<Header> list) {
        if (framedConnection == null) {
            throw new NullPointerException("connection == null");
        }
        if (list == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = n2;
        this.connection = framedConnection;
        this.bytesLeftInWriteWindow = framedConnection.peerSettings.getInitialWindowSize(65536);
        this.source = new FramedStream$FramedDataSource(this, framedConnection.okHttpSettings.getInitialWindowSize(65536), null);
        this.sink = new FramedStream$FramedDataSink(this);
        FramedStream$FramedDataSource.access$102(this.source, bl2);
        FramedStream$FramedDataSink.access$202(this.sink, bl);
        this.requestHeaders = list;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !FramedStream$FramedDataSource.access$100(this.source) && !FramedStream$FramedDataSource.access$300(this.source) || !FramedStream$FramedDataSink.access$200(this.sink) && !FramedStream$FramedDataSink.access$400(this.sink) || this.responseHeaders == null;
    }

    public final boolean isLocallyInitiated() {
        boolean bl;
        boolean bl2 = bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public final FramedConnection getConnection() {
        return this.connection;
    }

    public final List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public final synchronized List<Header> getResponseHeaders() throws IOException {
        this.readTimeout.enter();
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (this.responseHeaders != null) {
            return this.responseHeaders;
        }
        throw new StreamResetException(this.errorCode);
    }

    public final synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reply(List<Header> list, boolean bl) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean bl2 = false;
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (list == null) {
                throw new NullPointerException("responseHeaders == null");
            }
            if (this.responseHeaders != null) {
                throw new IllegalStateException("reply already sent");
            }
            this.responseHeaders = list;
            if (!bl) {
                FramedStream$FramedDataSink.access$202(this.sink, true);
                bl2 = true;
            }
        }
        this.connection.writeSynReply(this.id, bl2, list);
        if (bl2) {
            this.connection.flush();
        }
    }

    public final Timeout readTimeout() {
        return this.readTimeout;
    }

    public final Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public final Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sink getSink() {
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.sink;
    }

    public final void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public final void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (this.errorCode != null) {
                return false;
            }
            if (FramedStream$FramedDataSource.access$100(this.source) && FramedStream$FramedDataSink.access$200(this.sink)) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveHeaders(List<Header> list, HeadersMode object) {
        assert (!Thread.holdsLock(this));
        ErrorCode errorCode = null;
        boolean bl = true;
        FramedStream framedStream = this;
        synchronized (framedStream) {
            if (this.responseHeaders == null) {
                if (((HeadersMode)((Object)object)).failIfHeadersAbsent()) {
                    errorCode = ErrorCode.PROTOCOL_ERROR;
                } else {
                    this.responseHeaders = list;
                    bl = this.isOpen();
                    this.notifyAll();
                }
            } else if (((HeadersMode)((Object)object)).failIfHeadersPresent()) {
                errorCode = ErrorCode.STREAM_IN_USE;
            } else {
                object = new ArrayList<Header>();
                object.addAll(this.responseHeaders);
                object.addAll(list);
                this.responseHeaders = object;
            }
        }
        if (errorCode != null) {
            this.closeLater(errorCode);
            return;
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final void receiveData(BufferedSource bufferedSource, int n2) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(bufferedSource, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveFin() {
        boolean bl;
        assert (!Thread.holdsLock(this));
        FramedStream framedStream = this;
        synchronized (framedStream) {
            FramedStream$FramedDataSource.access$102(this.source, true);
            bl = this.isOpen();
            this.notifyAll();
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelStreamIfNecessary() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!Thread.holdsLock(this));
        FramedStream framedStream = this;
        synchronized (framedStream) {
            bl2 = !FramedStream$FramedDataSource.access$100(this.source) && FramedStream$FramedDataSource.access$300(this.source) && (FramedStream$FramedDataSink.access$200(this.sink) || FramedStream$FramedDataSink.access$400(this.sink));
            bl = this.isOpen();
        }
        if (bl2) {
            this.close(ErrorCode.CANCEL);
            return;
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    private void checkOutNotClosed() throws IOException {
        if (FramedStream$FramedDataSink.access$400(this.sink)) {
            throw new IOException("stream closed");
        }
        if (FramedStream$FramedDataSink.access$200(this.sink)) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw new StreamResetException(this.errorCode);
        }
    }

    private void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    static /* synthetic */ FramedConnection access$500(FramedStream framedStream) {
        return framedStream.connection;
    }

    static /* synthetic */ int access$600(FramedStream framedStream) {
        return framedStream.id;
    }

    static /* synthetic */ FramedStream$StreamTimeout access$700(FramedStream framedStream) {
        return framedStream.readTimeout;
    }

    static /* synthetic */ ErrorCode access$800(FramedStream framedStream) {
        return framedStream.errorCode;
    }

    static /* synthetic */ void access$900(FramedStream framedStream) throws InterruptedIOException {
        framedStream.waitForIo();
    }

    static /* synthetic */ void access$1000(FramedStream framedStream) throws IOException {
        framedStream.cancelStreamIfNecessary();
    }

    static /* synthetic */ FramedStream$StreamTimeout access$1100(FramedStream framedStream) {
        return framedStream.writeTimeout;
    }

    static /* synthetic */ void access$1200(FramedStream framedStream) throws IOException {
        framedStream.checkOutNotClosed();
    }
}

