/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.Handshake;
import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.Response$1;
import com.zoyi.retrofit2.okhttp3.ResponseBody;

public class Response$Builder {
    private Request request;
    private Protocol protocol;
    private int code = -1;
    private String message;
    private Handshake handshake;
    private Headers$Builder headers;
    private ResponseBody body;
    private Response networkResponse;
    private Response cacheResponse;
    private Response priorResponse;
    private long sentRequestAtMillis;
    private long receivedResponseAtMillis;

    public Response$Builder() {
        this.headers = new Headers$Builder();
    }

    private Response$Builder(Response response) {
        this.request = Response.access$1300(response);
        this.protocol = Response.access$1400(response);
        this.code = Response.access$1500(response);
        this.message = Response.access$1600(response);
        this.handshake = Response.access$1700(response);
        this.headers = Response.access$1800(response).newBuilder();
        this.body = Response.access$1900(response);
        this.networkResponse = Response.access$2000(response);
        this.cacheResponse = Response.access$2100(response);
        this.priorResponse = Response.access$2200(response);
        this.sentRequestAtMillis = Response.access$2300(response);
        this.receivedResponseAtMillis = Response.access$2400(response);
    }

    public Response$Builder request(Request request) {
        this.request = request;
        return this;
    }

    public Response$Builder protocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Response$Builder code(int n2) {
        this.code = n2;
        return this;
    }

    public Response$Builder message(String string) {
        this.message = string;
        return this;
    }

    public Response$Builder handshake(Handshake handshake) {
        this.handshake = handshake;
        return this;
    }

    public Response$Builder header(String string, String string2) {
        this.headers.set(string, string2);
        return this;
    }

    public Response$Builder addHeader(String string, String string2) {
        this.headers.add(string, string2);
        return this;
    }

    public Response$Builder removeHeader(String string) {
        this.headers.removeAll(string);
        return this;
    }

    public Response$Builder headers(Headers headers) {
        this.headers = headers.newBuilder();
        return this;
    }

    public Response$Builder body(ResponseBody responseBody) {
        this.body = responseBody;
        return this;
    }

    public Response$Builder networkResponse(Response response) {
        if (response != null) {
            this.checkSupportResponse("networkResponse", response);
        }
        this.networkResponse = response;
        return this;
    }

    public Response$Builder cacheResponse(Response response) {
        if (response != null) {
            this.checkSupportResponse("cacheResponse", response);
        }
        this.cacheResponse = response;
        return this;
    }

    private void checkSupportResponse(String string, Response response) {
        if (Response.access$1900(response) != null) {
            throw new IllegalArgumentException(string + ".body != null");
        }
        if (Response.access$2000(response) != null) {
            throw new IllegalArgumentException(string + ".networkResponse != null");
        }
        if (Response.access$2100(response) != null) {
            throw new IllegalArgumentException(string + ".cacheResponse != null");
        }
        if (Response.access$2200(response) != null) {
            throw new IllegalArgumentException(string + ".priorResponse != null");
        }
    }

    public Response$Builder priorResponse(Response response) {
        if (response != null) {
            this.checkPriorResponse(response);
        }
        this.priorResponse = response;
        return this;
    }

    private void checkPriorResponse(Response response) {
        if (Response.access$1900(response) != null) {
            throw new IllegalArgumentException("priorResponse.body != null");
        }
    }

    public Response$Builder sentRequestAtMillis(long l2) {
        this.sentRequestAtMillis = l2;
        return this;
    }

    public Response$Builder receivedResponseAtMillis(long l2) {
        this.receivedResponseAtMillis = l2;
        return this;
    }

    public Response build() {
        if (this.request == null) {
            throw new IllegalStateException("request == null");
        }
        if (this.protocol == null) {
            throw new IllegalStateException("protocol == null");
        }
        if (this.code < 0) {
            throw new IllegalStateException("code < 0: " + this.code);
        }
        return new Response(this, null);
    }

    static /* synthetic */ Request access$000(Response$Builder response$Builder) {
        return response$Builder.request;
    }

    static /* synthetic */ Protocol access$100(Response$Builder response$Builder) {
        return response$Builder.protocol;
    }

    static /* synthetic */ int access$200(Response$Builder response$Builder) {
        return response$Builder.code;
    }

    static /* synthetic */ String access$300(Response$Builder response$Builder) {
        return response$Builder.message;
    }

    static /* synthetic */ Handshake access$400(Response$Builder response$Builder) {
        return response$Builder.handshake;
    }

    static /* synthetic */ Headers$Builder access$500(Response$Builder response$Builder) {
        return response$Builder.headers;
    }

    static /* synthetic */ ResponseBody access$600(Response$Builder response$Builder) {
        return response$Builder.body;
    }

    static /* synthetic */ Response access$700(Response$Builder response$Builder) {
        return response$Builder.networkResponse;
    }

    static /* synthetic */ Response access$800(Response$Builder response$Builder) {
        return response$Builder.cacheResponse;
    }

    static /* synthetic */ Response access$900(Response$Builder response$Builder) {
        return response$Builder.priorResponse;
    }

    static /* synthetic */ long access$1000(Response$Builder response$Builder) {
        return response$Builder.sentRequestAtMillis;
    }

    static /* synthetic */ long access$1100(Response$Builder response$Builder) {
        return response$Builder.receivedResponseAtMillis;
    }

    /* synthetic */ Response$Builder(Response response, Response$1 response$1) {
        this(response);
    }
}

