/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.HttpUrl$1;
import com.zoyi.retrofit2.okhttp3.HttpUrl$Builder;
import com.zoyi.retrofit2.okhttp3.HttpUrl$Builder$ParseResult;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.Buffer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_ENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;

    private HttpUrl(HttpUrl$Builder httpUrl$Builder) {
        this.scheme = httpUrl$Builder.scheme;
        this.username = HttpUrl.percentDecode(httpUrl$Builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(httpUrl$Builder.encodedPassword, false);
        this.host = httpUrl$Builder.host;
        this.port = httpUrl$Builder.effectivePort();
        this.pathSegments = this.percentDecode(httpUrl$Builder.encodedPathSegments, false);
        this.queryNamesAndValues = httpUrl$Builder.encodedQueryNamesAndValues != null ? this.percentDecode(httpUrl$Builder.encodedQueryNamesAndValues, true) : null;
        this.fragment = httpUrl$Builder.encodedFragment != null ? HttpUrl.percentDecode(httpUrl$Builder.encodedFragment, false) : null;
        this.url = httpUrl$Builder.toString();
    }

    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public final URI uri() {
        String string = this.newBuilder().reencodeForUri().toString();
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                string = string.replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET);
                return URI.create(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public final String scheme() {
        return this.scheme;
    }

    public final boolean isHttps() {
        return this.scheme.equals("https");
    }

    public final String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.scheme.length() + 3;
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), ":@");
        return this.url.substring(n2, n3);
    }

    public final String username() {
        return this.username;
    }

    public final String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n2 = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n3 = this.url.indexOf(64);
        return this.url.substring(n2, n3);
    }

    public final String password() {
        return this.password;
    }

    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    public static int defaultPort(String string) {
        if (string.equals("http")) {
            return 80;
        }
        if (string.equals("https")) {
            return 443;
        }
        return -1;
    }

    public final int pathSize() {
        return this.pathSegments.size();
    }

    public final String encodedPath() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), "?#");
        return this.url.substring(n2, n3);
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i2));
        }
    }

    public final List<String> encodedPathSegments() {
        int n2 = this.url.indexOf(47, this.scheme.length() + 3);
        int n3 = Util.delimiterOffset(this.url, n2, this.url.length(), "?#");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n2 < n3) {
            int n4 = Util.delimiterOffset(this.url, ++n2, n3, '/');
            arrayList.add(this.url.substring(n2, n4));
            n2 = n4;
        }
        return arrayList;
    }

    public final List<String> pathSegments() {
        return this.pathSegments;
    }

    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.url.indexOf(63) + 1;
        int n3 = Util.delimiterOffset(this.url, n2 + 1, this.url.length(), '#');
        return this.url.substring(n2, n3);
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            String string = list.get(i2);
            String string2 = list.get(i2 + 1);
            if (i2 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string2);
        }
    }

    static List<String> queryStringToNamesAndValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 <= string.length()) {
            int n3;
            int n4 = string.indexOf(38, n2);
            if (n4 == -1) {
                n4 = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n4) {
                arrayList.add(string.substring(n2, n4));
                arrayList.add(null);
            } else {
                arrayList.add(string.substring(n2, n3));
                arrayList.add(string.substring(n3 + 1, n4));
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }

    public final String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public final int querySize() {
        if (this.queryNamesAndValues != null) {
            return this.queryNamesAndValues.size() / 2;
        }
        return 0;
    }

    public final String queryParameter(String string) {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i2))) continue;
            return this.queryNamesAndValues.get(i2 + 1);
        }
        return null;
    }

    public final Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            linkedHashSet.add(this.queryNamesAndValues.get(i2));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public final List<String> queryParameterValues(String string) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.queryNamesAndValues.size();
        for (int i2 = 0; i2 < n2; i2 += 2) {
            if (!string.equals(this.queryNamesAndValues.get(i2))) continue;
            arrayList.add(this.queryNamesAndValues.get(i2 + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final String queryParameterName(int n2) {
        return this.queryNamesAndValues.get(n2 << 1);
    }

    public final String queryParameterValue(int n2) {
        return this.queryNamesAndValues.get((n2 << 1) + 1);
    }

    public final String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n2 = this.url.indexOf(35) + 1;
        return this.url.substring(n2);
    }

    public final String fragment() {
        return this.fragment;
    }

    public final HttpUrl resolve(String object) {
        if ((object = this.newBuilder((String)object)) != null) {
            return ((HttpUrl$Builder)object).build();
        }
        return null;
    }

    public final HttpUrl$Builder newBuilder() {
        HttpUrl$Builder httpUrl$Builder = new HttpUrl$Builder();
        new HttpUrl$Builder().scheme = this.scheme;
        httpUrl$Builder.encodedUsername = this.encodedUsername();
        httpUrl$Builder.encodedPassword = this.encodedPassword();
        httpUrl$Builder.host = this.host;
        httpUrl$Builder.port = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        httpUrl$Builder.encodedPathSegments.clear();
        httpUrl$Builder.encodedPathSegments.addAll(this.encodedPathSegments());
        httpUrl$Builder.encodedQuery(this.encodedQuery());
        httpUrl$Builder.encodedFragment = this.encodedFragment();
        return httpUrl$Builder;
    }

    public final HttpUrl$Builder newBuilder(String object) {
        HttpUrl$Builder httpUrl$Builder = new HttpUrl$Builder();
        if ((object = httpUrl$Builder.parse(this, (String)object)) == HttpUrl$Builder$ParseResult.SUCCESS) {
            return httpUrl$Builder;
        }
        return null;
    }

    public static HttpUrl parse(String object) {
        HttpUrl$Builder httpUrl$Builder = new HttpUrl$Builder();
        if ((object = httpUrl$Builder.parse(null, (String)object)) == HttpUrl$Builder$ParseResult.SUCCESS) {
            return httpUrl$Builder.build();
        }
        return null;
    }

    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    static HttpUrl getChecked(String string) throws MalformedURLException, UnknownHostException {
        HttpUrl$Builder httpUrl$Builder = new HttpUrl$Builder();
        HttpUrl$Builder$ParseResult httpUrl$Builder$ParseResult = httpUrl$Builder.parse(null, string);
        switch (httpUrl$Builder$ParseResult) {
            case SUCCESS: {
                return httpUrl$Builder.build();
            }
            case INVALID_HOST: {
                throw new UnknownHostException("Invalid host: " + string);
            }
        }
        throw new MalformedURLException("Invalid URL: " + (Object)((Object)httpUrl$Builder$ParseResult) + " for " + string);
    }

    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    public final boolean equals(Object object) {
        return object instanceof HttpUrl && ((HttpUrl)object).url.equals(this.url);
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final String toString() {
        return this.url;
    }

    static String percentDecode(String string, boolean bl) {
        return HttpUrl.percentDecode(string, 0, string.length(), bl);
    }

    private List<String> percentDecode(List<String> object, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            arrayList.add(string != null ? HttpUrl.percentDecode(string, bl) : null);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String percentDecode(String string, int n2, int n3, boolean bl) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '%' && (c2 != '+' || !bl)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n2, i2);
            HttpUrl.percentDecode(buffer, string, i2, n3, bl);
            return buffer.readUtf8();
        }
        return string.substring(n2, n3);
    }

    static void percentDecode(Buffer buffer, String string, int n2, int n3, boolean bl) {
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (n2 == 37 && i2 + 2 < n3) {
                int n4 = HttpUrl.decodeHexDigit(string.charAt(i2 + 1));
                int n5 = HttpUrl.decodeHexDigit(string.charAt(i2 + 2));
                if (n4 != -1 && n5 != -1) {
                    buffer.writeByte((n4 << 4) + n5);
                    i2 += 2;
                    continue;
                }
            } else if (n2 == 43 && bl) {
                buffer.writeByte(32);
                continue;
            }
            buffer.writeUtf8CodePoint(n2);
        }
    }

    static boolean percentEncoded(String string, int n2, int n3) {
        return n2 + 2 < n3 && string.charAt(n2) == '%' && HttpUrl.decodeHexDigit(string.charAt(n2 + 1)) != -1 && HttpUrl.decodeHexDigit(string.charAt(n2 + 2)) != -1;
    }

    static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    static String canonicalize(String string, int n2, int n3, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!(n4 < 32 || n4 == 127 || n4 >= 128 && bl4 || string2.indexOf(n4) != -1 || n4 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string, i2, n3))) && (n4 != 43 || !bl3)) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, n2, i2);
            HttpUrl.canonicalize(buffer, string, i2, n3, string2, bl, bl2, bl3, bl4);
            return buffer.readUtf8();
        }
        return string.substring(n2, n3);
    }

    static void canonicalize(Buffer buffer, String string, int n2, int n3, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Buffer buffer2 = null;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (bl && (n2 == 9 || n2 == 10 || n2 == 12 || n2 == 13)) continue;
            if (n2 == 43 && bl3) {
                buffer.writeUtf8(bl ? "+" : "%2B");
                continue;
            }
            if (n2 < 32 || n2 == 127 || n2 >= 128 && bl4 || string2.indexOf(n2) != -1 || n2 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string, i2, n3))) {
                if (buffer2 == null) {
                    buffer2 = new Buffer();
                }
                buffer2.writeUtf8CodePoint(n2);
                while (!buffer2.exhausted()) {
                    int n4 = buffer2.readByte() & 0xFF;
                    buffer.writeByte(37);
                    buffer.writeByte(HEX_DIGITS[n4 >> 4 & 0xF]);
                    buffer.writeByte(HEX_DIGITS[n4 & 0xF]);
                }
                continue;
            }
            buffer.writeUtf8CodePoint(n2);
        }
    }

    static String canonicalize(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return HttpUrl.canonicalize(string, 0, string.length(), string2, bl, bl2, bl3, bl4);
    }

    /* synthetic */ HttpUrl(HttpUrl$Builder httpUrl$Builder, HttpUrl$1 httpUrl$1) {
        this(httpUrl$Builder);
    }

    static /* synthetic */ String access$100(HttpUrl httpUrl) {
        return httpUrl.scheme;
    }

    static /* synthetic */ String access$200(HttpUrl httpUrl) {
        return httpUrl.host;
    }

    static /* synthetic */ int access$300(HttpUrl httpUrl) {
        return httpUrl.port;
    }
}

