/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.okhttp3;

import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.HttpUrl$Builder$ParseResult;
import com.zoyi.retrofit2.okhttp3.internal.Util;
import com.zoyi.retrofit2.okio.Buffer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class HttpUrl$Builder {
    String scheme;
    String encodedUsername = "";
    String encodedPassword = "";
    String host;
    int port = -1;
    final List<String> encodedPathSegments = new ArrayList<String>();
    List<String> encodedQueryNamesAndValues;
    String encodedFragment;

    public HttpUrl$Builder() {
        this.encodedPathSegments.add("");
    }

    public final HttpUrl$Builder scheme(String string) {
        if (string == null) {
            throw new NullPointerException("scheme == null");
        }
        if (string.equalsIgnoreCase("http")) {
            this.scheme = "http";
        } else if (string.equalsIgnoreCase("https")) {
            this.scheme = "https";
        } else {
            throw new IllegalArgumentException("unexpected scheme: " + string);
        }
        return this;
    }

    public final HttpUrl$Builder username(String string) {
        if (string == null) {
            throw new NullPointerException("username == null");
        }
        this.encodedUsername = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
        return this;
    }

    public final HttpUrl$Builder encodedUsername(String string) {
        if (string == null) {
            throw new NullPointerException("encodedUsername == null");
        }
        this.encodedUsername = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
        return this;
    }

    public final HttpUrl$Builder password(String string) {
        if (string == null) {
            throw new NullPointerException("password == null");
        }
        this.encodedPassword = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
        return this;
    }

    public final HttpUrl$Builder encodedPassword(String string) {
        if (string == null) {
            throw new NullPointerException("encodedPassword == null");
        }
        this.encodedPassword = HttpUrl.canonicalize(string, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
        return this;
    }

    public final HttpUrl$Builder host(String string) {
        if (string == null) {
            throw new NullPointerException("host == null");
        }
        String string2 = HttpUrl$Builder.canonicalizeHost(string, 0, string.length());
        if (string2 == null) {
            throw new IllegalArgumentException("unexpected host: " + string);
        }
        this.host = string2;
        return this;
    }

    public final HttpUrl$Builder port(int n2) {
        if (n2 <= 0 || n2 > 65535) {
            throw new IllegalArgumentException("unexpected port: " + n2);
        }
        this.port = n2;
        return this;
    }

    final int effectivePort() {
        if (this.port != -1) {
            return this.port;
        }
        return HttpUrl.defaultPort(this.scheme);
    }

    public final HttpUrl$Builder addPathSegment(String string) {
        if (string == null) {
            throw new NullPointerException("pathSegment == null");
        }
        this.push(string, 0, string.length(), false, false);
        return this;
    }

    public final HttpUrl$Builder addPathSegments(String string) {
        if (string == null) {
            throw new NullPointerException("pathSegments == null");
        }
        return this.addPathSegments(string, false);
    }

    public final HttpUrl$Builder addEncodedPathSegment(String string) {
        if (string == null) {
            throw new NullPointerException("encodedPathSegment == null");
        }
        this.push(string, 0, string.length(), false, true);
        return this;
    }

    public final HttpUrl$Builder addEncodedPathSegments(String string) {
        if (string == null) {
            throw new NullPointerException("encodedPathSegments == null");
        }
        return this.addPathSegments(string, true);
    }

    private HttpUrl$Builder addPathSegments(String string, boolean bl) {
        int n2;
        int n3 = 0;
        do {
            boolean bl2 = (n2 = Util.delimiterOffset(string, n3, string.length(), "/\\")) < string.length();
            this.push(string, n3, n2, bl2, bl);
        } while ((n3 = n2 + 1) <= string.length());
        return this;
    }

    public final HttpUrl$Builder setPathSegment(int n2, String string) {
        if (string == null) {
            throw new NullPointerException("pathSegment == null");
        }
        String string2 = HttpUrl.canonicalize(string, 0, string.length(), " \"<>^`{}|/\\?#", false, false, false, true);
        if (this.isDot(string2) || this.isDotDot(string2)) {
            throw new IllegalArgumentException("unexpected path segment: " + string);
        }
        this.encodedPathSegments.set(n2, string2);
        return this;
    }

    public final HttpUrl$Builder setEncodedPathSegment(int n2, String string) {
        if (string == null) {
            throw new NullPointerException("encodedPathSegment == null");
        }
        String string2 = HttpUrl.canonicalize(string, 0, string.length(), " \"<>^`{}|/\\?#", true, false, false, true);
        this.encodedPathSegments.set(n2, string2);
        if (this.isDot(string2) || this.isDotDot(string2)) {
            throw new IllegalArgumentException("unexpected path segment: " + string);
        }
        return this;
    }

    public final HttpUrl$Builder removePathSegment(int n2) {
        this.encodedPathSegments.remove(n2);
        if (this.encodedPathSegments.isEmpty()) {
            this.encodedPathSegments.add("");
        }
        return this;
    }

    public final HttpUrl$Builder encodedPath(String string) {
        if (string == null) {
            throw new NullPointerException("encodedPath == null");
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException("unexpected encodedPath: " + string);
        }
        this.resolvePath(string, 0, string.length());
        return this;
    }

    public final HttpUrl$Builder query(String string) {
        this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, " \"'<>#", false, false, true, true)) : null;
        return this;
    }

    public final HttpUrl$Builder encodedQuery(String string) {
        this.encodedQueryNamesAndValues = string != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, " \"'<>#", true, false, true, true)) : null;
        return this;
    }

    public final HttpUrl$Builder addQueryParameter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            this.encodedQueryNamesAndValues = new ArrayList<String>();
        }
        this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, " \"'<>#&=", false, false, true, true));
        this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, " \"'<>#&=", false, false, true, true) : null);
        return this;
    }

    public final HttpUrl$Builder addEncodedQueryParameter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("encodedName == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            this.encodedQueryNamesAndValues = new ArrayList<String>();
        }
        this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string, " \"'<>#&=", true, false, true, true));
        this.encodedQueryNamesAndValues.add(string2 != null ? HttpUrl.canonicalize(string2, " \"'<>#&=", true, false, true, true) : null);
        return this;
    }

    public final HttpUrl$Builder setQueryParameter(String string, String string2) {
        this.removeAllQueryParameters(string);
        this.addQueryParameter(string, string2);
        return this;
    }

    public final HttpUrl$Builder setEncodedQueryParameter(String string, String string2) {
        this.removeAllEncodedQueryParameters(string);
        this.addEncodedQueryParameter(string, string2);
        return this;
    }

    public final HttpUrl$Builder removeAllQueryParameters(String string) {
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            return this;
        }
        string = HttpUrl.canonicalize(string, " \"'<>#&=", false, false, true, true);
        this.removeAllCanonicalQueryParameters(string);
        return this;
    }

    public final HttpUrl$Builder removeAllEncodedQueryParameters(String string) {
        if (string == null) {
            throw new NullPointerException("encodedName == null");
        }
        if (this.encodedQueryNamesAndValues == null) {
            return this;
        }
        this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string, " \"'<>#&=", true, false, true, true));
        return this;
    }

    private void removeAllCanonicalQueryParameters(String string) {
        for (int i2 = this.encodedQueryNamesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
            if (!string.equals(this.encodedQueryNamesAndValues.get(i2))) continue;
            this.encodedQueryNamesAndValues.remove(i2 + 1);
            this.encodedQueryNamesAndValues.remove(i2);
            if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
            this.encodedQueryNamesAndValues = null;
            return;
        }
    }

    public final HttpUrl$Builder fragment(String string) {
        this.encodedFragment = string != null ? HttpUrl.canonicalize(string, "", false, false, false, false) : null;
        return this;
    }

    public final HttpUrl$Builder encodedFragment(String string) {
        this.encodedFragment = string != null ? HttpUrl.canonicalize(string, "", true, false, false, false) : null;
        return this;
    }

    final HttpUrl$Builder reencodeForUri() {
        String string;
        int n2;
        int n3 = this.encodedPathSegments.size();
        for (n2 = 0; n2 < n3; ++n2) {
            string = this.encodedPathSegments.get(n2);
            this.encodedPathSegments.set(n2, HttpUrl.canonicalize(string, "[]", true, true, false, true));
        }
        if (this.encodedQueryNamesAndValues != null) {
            n3 = this.encodedQueryNamesAndValues.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string = this.encodedQueryNamesAndValues.get(n2);
                if (string == null) continue;
                this.encodedQueryNamesAndValues.set(n2, HttpUrl.canonicalize(string, "\\^`{|}", true, true, true, true));
            }
        }
        if (this.encodedFragment != null) {
            this.encodedFragment = HttpUrl.canonicalize(this.encodedFragment, " \"#<>\\^`{|}", true, true, false, false);
        }
        return this;
    }

    public final HttpUrl build() {
        if (this.scheme == null) {
            throw new IllegalStateException("scheme == null");
        }
        if (this.host == null) {
            throw new IllegalStateException("host == null");
        }
        return new HttpUrl(this, null);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.scheme);
        stringBuilder.append("://");
        if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
            stringBuilder.append(this.encodedUsername);
            if (!this.encodedPassword.isEmpty()) {
                stringBuilder.append(':');
                stringBuilder.append(this.encodedPassword);
            }
            stringBuilder.append('@');
        }
        if (this.host.indexOf(58) != -1) {
            stringBuilder.append('[');
            stringBuilder.append(this.host);
            stringBuilder.append(']');
        } else {
            stringBuilder.append(this.host);
        }
        int n2 = this.effectivePort();
        if (n2 != HttpUrl.defaultPort(this.scheme)) {
            stringBuilder.append(':');
            stringBuilder.append(n2);
        }
        HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
        if (this.encodedQueryNamesAndValues != null) {
            stringBuilder.append('?');
            HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
        }
        if (this.encodedFragment != null) {
            stringBuilder.append('#');
            stringBuilder.append(this.encodedFragment);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final HttpUrl$Builder$ParseResult parse(HttpUrl httpUrl, String string) {
        int n2;
        int n3;
        int n4;
        block19: {
            n4 = Util.skipLeadingAsciiWhitespace(string, 0, string.length());
            int n5 = HttpUrl$Builder.schemeDelimiterOffset(string, n4, n3 = Util.skipTrailingAsciiWhitespace(string, n4, string.length()));
            if (n5 != -1) {
                if (string.regionMatches(true, n4, "https:", 0, 6)) {
                    this.scheme = "https";
                    n4 += 6;
                } else {
                    if (!string.regionMatches(true, n4, "http:", 0, 5)) return HttpUrl$Builder$ParseResult.UNSUPPORTED_SCHEME;
                    this.scheme = "http";
                    n4 += 5;
                }
            } else {
                if (httpUrl == null) return HttpUrl$Builder$ParseResult.MISSING_SCHEME;
                this.scheme = HttpUrl.access$100(httpUrl);
            }
            n5 = 0;
            boolean bl = false;
            n2 = HttpUrl$Builder.slashCount(string, n4, n3);
            if (n2 >= 2 || httpUrl == null || !HttpUrl.access$100(httpUrl).equals(this.scheme)) {
                n4 += n2;
                while (true) {
                    int n6;
                    n2 = (n6 = Util.delimiterOffset(string, n4, n3, "@/\\?#")) != n3 ? (int)string.charAt(n6) : -1;
                    switch (n2) {
                        case 64: {
                            if (!bl) {
                                n2 = Util.delimiterOffset(string, n4, n6, ':');
                                String string2 = HttpUrl.canonicalize(string, n4, n2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                                String string3 = this.encodedUsername = n5 != 0 ? this.encodedUsername + "%40" + string2 : string2;
                                if (n2 != n6) {
                                    bl = true;
                                    this.encodedPassword = HttpUrl.canonicalize(string, n2 + 1, n6, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                                }
                                n5 = 1;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + HttpUrl.canonicalize(string, n4, n6, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                            }
                            n4 = n6 + 1;
                            break;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            n2 = HttpUrl$Builder.portColonOffset(string, n4, n6);
                            if (n2 + 1 < n6) {
                                this.host = HttpUrl$Builder.canonicalizeHost(string, n4, n2);
                                this.port = HttpUrl$Builder.parsePort(string, n2 + 1, n6);
                                if (this.port == -1) {
                                    return HttpUrl$Builder$ParseResult.INVALID_PORT;
                                }
                            } else {
                                this.host = HttpUrl$Builder.canonicalizeHost(string, n4, n2);
                                this.port = HttpUrl.defaultPort(this.scheme);
                            }
                            if (this.host == null) {
                                return HttpUrl$Builder$ParseResult.INVALID_HOST;
                            }
                            n4 = n6;
                            break block19;
                        }
                    }
                }
            }
            this.encodedUsername = httpUrl.encodedUsername();
            this.encodedPassword = httpUrl.encodedPassword();
            this.host = HttpUrl.access$200(httpUrl);
            this.port = HttpUrl.access$300(httpUrl);
            this.encodedPathSegments.clear();
            this.encodedPathSegments.addAll(httpUrl.encodedPathSegments());
            if (n4 == n3 || string.charAt(n4) == '#') {
                this.encodedQuery(httpUrl.encodedQuery());
            }
        }
        int n7 = Util.delimiterOffset(string, n4, n3, "?#");
        this.resolvePath(string, n4, n7);
        n4 = n7;
        if (n4 < n3 && string.charAt(n4) == '?') {
            n2 = Util.delimiterOffset(string, n4, n3, '#');
            this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string, n4 + 1, n2, " \"'<>#", true, false, true, true));
            n4 = n2;
        }
        if (n4 >= n3 || string.charAt(n4) != '#') return HttpUrl$Builder$ParseResult.SUCCESS;
        this.encodedFragment = HttpUrl.canonicalize(string, n4 + 1, n3, "", true, false, false, false);
        return HttpUrl$Builder$ParseResult.SUCCESS;
    }

    private void resolvePath(String string, int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        int n4 = string.charAt(n2);
        if (n4 == 47 || n4 == 92) {
            this.encodedPathSegments.clear();
            this.encodedPathSegments.add("");
            ++n2;
        } else {
            this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
        }
        while (n2 < n3) {
            n4 = Util.delimiterOffset(string, n2, n3, "/\\");
            boolean bl = n4 < n3;
            this.push(string, n2, n4, bl, true);
            n2 = n4;
            if (!bl) continue;
            ++n2;
        }
    }

    private void push(String string, int n2, int n3, boolean bl, boolean bl2) {
        if (this.isDot(string = HttpUrl.canonicalize(string, n2, n3, " \"<>^`{}|/\\?#", bl2, false, false, true))) {
            return;
        }
        if (this.isDotDot(string)) {
            this.pop();
            return;
        }
        if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
            this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, string);
        } else {
            this.encodedPathSegments.add(string);
        }
        if (bl) {
            this.encodedPathSegments.add("");
        }
    }

    private boolean isDot(String string) {
        return string.equals(".") || string.equalsIgnoreCase("%2e");
    }

    private boolean isDotDot(String string) {
        return string.equals("..") || string.equalsIgnoreCase("%2e.") || string.equalsIgnoreCase(".%2e") || string.equalsIgnoreCase("%2e%2e");
    }

    private void pop() {
        String string = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
        if (string.isEmpty() && !this.encodedPathSegments.isEmpty()) {
            this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
            return;
        }
        this.encodedPathSegments.add("");
    }

    private static int schemeDelimiterOffset(String string, int n2, int n3) {
        if (n3 - n2 < 2) {
            return -1;
        }
        char c2 = string.charAt(n2);
        if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            return -1;
        }
        ++n2;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '+' || c2 == '-' || c2 == '.')) {
                if (c2 == ':') {
                    return n2;
                }
                return -1;
            }
            ++n2;
        }
        return -1;
    }

    private static int slashCount(String string, int n2, int n3) {
        char c2;
        int n4 = 0;
        while (n2 < n3 && ((c2 = string.charAt(n2)) == '\\' || c2 == '/')) {
            ++n4;
            ++n2;
        }
        return n4;
    }

    private static int portColonOffset(String string, int n2, int n3) {
        while (n2 < n3) {
            switch (string.charAt(n2)) {
                case '[': {
                    while (++n2 < n3 && string.charAt(n2) != ']') {
                    }
                    break;
                }
                case ':': {
                    return n2;
                }
            }
            ++n2;
        }
        return n3;
    }

    private static String canonicalizeHost(String object, int n2, int n3) {
        if (((String)(object = HttpUrl.percentDecode((String)object, n2, n3, false))).contains(":")) {
            if ((object = ((String)object).startsWith("[") && ((String)object).endsWith("]") ? HttpUrl$Builder.decodeIpv6((String)object, 1, ((String)object).length() - 1) : HttpUrl$Builder.decodeIpv6((String)object, 0, ((String)object).length())) == null) {
                return null;
            }
            byte[] byArray = ((InetAddress)object).getAddress();
            object = byArray;
            if (byArray.length == 16) {
                return HttpUrl$Builder.inet6AddressToAscii((byte[])object);
            }
            throw new AssertionError();
        }
        return Util.domainToAscii((String)object);
    }

    private static InetAddress decodeIpv6(String string, int n2, int n3) {
        byte[] byArray = new byte[16];
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        while (n2 < n3) {
            int n7;
            if (n4 == 16) {
                return null;
            }
            if (n2 + 2 <= n3 && string.regionMatches(n2, "::", 0, 2)) {
                if (n5 != -1) {
                    return null;
                }
                n5 = n4 += 2;
                if ((n2 += 2) == n3) {
                    break;
                }
            } else if (n4 != 0 && !string.regionMatches(n2, ":", 0, 1)) {
                if (string.regionMatches(n2, ".", 0, 1)) {
                    if (!HttpUrl$Builder.decodeIpv4Suffix(string, n6, n3, byArray, n4 - 2)) {
                        return null;
                    }
                    n4 += 2;
                    break;
                }
                return null;
            }
            int n8 = 0;
            n6 = ++n2;
            while (n2 < n3) {
                n7 = string.charAt(n2);
                if ((n7 = HttpUrl.decodeHexDigit((char)n7)) == -1) break;
                n8 = (n8 << 4) + n7;
                ++n2;
            }
            if ((n7 = n2 - n6) == 0 || n7 > 4) {
                return null;
            }
            byArray[n4++] = (byte)(n8 >>> 8);
            byArray[n4++] = (byte)n8;
        }
        if (n4 != 16) {
            if (n5 == -1) {
                return null;
            }
            System.arraycopy(byArray, n5, byArray, 16 - (n4 - n5), n4 - n5);
            Arrays.fill(byArray, n5, n5 + (16 - n4), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String string, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4;
        while (n2 < n3) {
            int n6;
            if (n5 == byArray.length) {
                return false;
            }
            if (n5 != n4 && string.charAt(n2) != '.') {
                return false;
            }
            int n7 = 0;
            int n8 = ++n2;
            while (n2 < n3 && (n6 = string.charAt(n2)) >= 48 && n6 <= 57) {
                if (n7 == 0 && n8 != n2) {
                    return false;
                }
                if ((n7 = n7 * 10 + n6 - 48) > 255) {
                    return false;
                }
                ++n2;
            }
            n6 = n2 - n8;
            if (n6 == 0) {
                return false;
            }
            byArray[n5++] = (byte)n7;
        }
        return n5 == n4 + 4;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            n3 = i2;
            while (i2 < 16 && byArray[i2] == 0 && byArray[i2 + 1] == 0) {
                i2 += 2;
            }
            n2 = i2 - n3;
            if (n2 <= n5) continue;
            n4 = n3;
            n5 = n2;
        }
        Buffer buffer = new Buffer();
        n3 = 0;
        while (n3 < byArray.length) {
            if (n3 == n4) {
                buffer.writeByte(58);
                if ((n3 += n5) != 16) continue;
                buffer.writeByte(58);
                continue;
            }
            if (n3 > 0) {
                buffer.writeByte(58);
            }
            n2 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
            buffer.writeHexadecimalUnsignedLong(n2);
            n3 += 2;
        }
        return buffer.readUtf8();
    }

    private static int parsePort(String string, int n2, int n3) {
        try {
            string = HttpUrl.canonicalize(string, n2, n3, "", false, false, false, true);
            int n4 = Integer.parseInt(string);
            if (n4 > 0 && n4 <= 65535) {
                return n4;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

