/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.Converter;
import com.zoyi.retrofit2.ParameterHandler;
import com.zoyi.retrofit2.ParameterHandler$Body;
import com.zoyi.retrofit2.ParameterHandler$Field;
import com.zoyi.retrofit2.ParameterHandler$FieldMap;
import com.zoyi.retrofit2.ParameterHandler$Header;
import com.zoyi.retrofit2.ParameterHandler$HeaderMap;
import com.zoyi.retrofit2.ParameterHandler$Part;
import com.zoyi.retrofit2.ParameterHandler$PartMap;
import com.zoyi.retrofit2.ParameterHandler$Path;
import com.zoyi.retrofit2.ParameterHandler$Query;
import com.zoyi.retrofit2.ParameterHandler$QueryMap;
import com.zoyi.retrofit2.ParameterHandler$RawPart;
import com.zoyi.retrofit2.ParameterHandler$RelativeUrl;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.ServiceMethod;
import com.zoyi.retrofit2.Utils;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.DELETE;
import com.zoyi.retrofit2.http.Field;
import com.zoyi.retrofit2.http.FieldMap;
import com.zoyi.retrofit2.http.FormUrlEncoded;
import com.zoyi.retrofit2.http.GET;
import com.zoyi.retrofit2.http.HEAD;
import com.zoyi.retrofit2.http.HTTP;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.retrofit2.http.HeaderMap;
import com.zoyi.retrofit2.http.Headers;
import com.zoyi.retrofit2.http.Multipart;
import com.zoyi.retrofit2.http.OPTIONS;
import com.zoyi.retrofit2.http.PATCH;
import com.zoyi.retrofit2.http.POST;
import com.zoyi.retrofit2.http.PUT;
import com.zoyi.retrofit2.http.Part;
import com.zoyi.retrofit2.http.PartMap;
import com.zoyi.retrofit2.http.Path;
import com.zoyi.retrofit2.http.Query;
import com.zoyi.retrofit2.http.QueryMap;
import com.zoyi.retrofit2.http.Url;
import com.zoyi.retrofit2.okhttp3.Headers$Builder;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.MediaType;
import com.zoyi.retrofit2.okhttp3.MultipartBody$Part;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

final class ServiceMethod$Builder<T> {
    final Retrofit retrofit;
    final Method method;
    final Annotation[] methodAnnotations;
    final Annotation[][] parameterAnnotationsArray;
    final Type[] parameterTypes;
    Type responseType;
    boolean gotField;
    boolean gotPart;
    boolean gotBody;
    boolean gotPath;
    boolean gotQuery;
    boolean gotUrl;
    String httpMethod;
    boolean hasBody;
    boolean isFormEncoded;
    boolean isMultipart;
    String relativeUrl;
    com.zoyi.retrofit2.okhttp3.Headers headers;
    MediaType contentType;
    Set<String> relativeUrlParamNames;
    ParameterHandler<?>[] parameterHandlers;
    Converter<ResponseBody, T> responseConverter;
    CallAdapter<?> callAdapter;

    public ServiceMethod$Builder(Retrofit retrofit, Method method) {
        this.retrofit = retrofit;
        this.method = method;
        this.methodAnnotations = method.getAnnotations();
        this.parameterTypes = method.getGenericParameterTypes();
        this.parameterAnnotationsArray = method.getParameterAnnotations();
    }

    public final ServiceMethod build() {
        Annotation[] annotationArray;
        this.callAdapter = this.createCallAdapter();
        this.responseType = this.callAdapter.responseType();
        if (this.responseType == com.zoyi.retrofit2.Response.class || this.responseType == Response.class) {
            throw this.methodError("'" + Utils.getRawType(this.responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
        }
        this.responseConverter = this.createResponseConverter();
        Annotation[] annotationArray2 = this.methodAnnotations;
        int n2 = this.methodAnnotations.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            annotationArray = annotationArray2[i2];
            this.parseMethodAnnotation((Annotation)annotationArray);
        }
        if (this.httpMethod == null) {
            throw this.methodError("HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
        }
        if (!this.hasBody) {
            if (this.isMultipart) {
                throw this.methodError("Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
            if (this.isFormEncoded) {
                throw this.methodError("FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
            }
        }
        int n3 = this.parameterAnnotationsArray.length;
        this.parameterHandlers = new ParameterHandler[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Type type = this.parameterTypes[n2];
            if (Utils.hasUnresolvableType(type)) {
                throw this.parameterError(n2, "Parameter type must not include a type variable or wildcard: %s", type);
            }
            annotationArray = this.parameterAnnotationsArray[n2];
            if (annotationArray == null) {
                throw this.parameterError(n2, "No Retrofit annotation found.", new Object[0]);
            }
            this.parameterHandlers[n2] = this.parseParameter(n2, type, annotationArray);
        }
        if (this.relativeUrl == null && !this.gotUrl) {
            throw this.methodError("Missing either @%s URL or @Url parameter.", this.httpMethod);
        }
        if (!this.isFormEncoded && !this.isMultipart && !this.hasBody && this.gotBody) {
            throw this.methodError("Non-body HTTP method cannot contain @Body.", new Object[0]);
        }
        if (this.isFormEncoded && !this.gotField) {
            throw this.methodError("Form-encoded method must contain at least one @Field.", new Object[0]);
        }
        if (this.isMultipart && !this.gotPart) {
            throw this.methodError("Multipart method must contain at least one @Part.", new Object[0]);
        }
        return new ServiceMethod(this);
    }

    private CallAdapter<?> createCallAdapter() {
        Type type = this.method.getGenericReturnType();
        if (Utils.hasUnresolvableType(type)) {
            throw this.methodError("Method return type must not include a type variable or wildcard: %s", type);
        }
        if (type == Void.TYPE) {
            throw this.methodError("Service methods cannot return void.", new Object[0]);
        }
        Annotation[] annotationArray = this.method.getAnnotations();
        try {
            return this.retrofit.callAdapter(type, annotationArray);
        }
        catch (RuntimeException runtimeException) {
            throw this.methodError(runtimeException, "Unable to create call adapter for %s", type);
        }
    }

    private void parseMethodAnnotation(Annotation stringArray) {
        if (stringArray instanceof DELETE) {
            this.parseHttpMethodAndPath("DELETE", ((DELETE)stringArray).value(), false);
            return;
        }
        if (stringArray instanceof GET) {
            this.parseHttpMethodAndPath("GET", ((GET)stringArray).value(), false);
            return;
        }
        if (stringArray instanceof HEAD) {
            this.parseHttpMethodAndPath("HEAD", ((HEAD)stringArray).value(), false);
            if (!Void.class.equals((Object)this.responseType)) {
                throw this.methodError("HEAD method must use Void as response type.", new Object[0]);
            }
        } else {
            if (stringArray instanceof PATCH) {
                this.parseHttpMethodAndPath("PATCH", ((PATCH)stringArray).value(), true);
                return;
            }
            if (stringArray instanceof POST) {
                this.parseHttpMethodAndPath("POST", ((POST)stringArray).value(), true);
                return;
            }
            if (stringArray instanceof PUT) {
                this.parseHttpMethodAndPath("PUT", ((PUT)stringArray).value(), true);
                return;
            }
            if (stringArray instanceof OPTIONS) {
                this.parseHttpMethodAndPath("OPTIONS", ((OPTIONS)stringArray).value(), false);
                return;
            }
            if (stringArray instanceof HTTP) {
                stringArray = (HTTP)stringArray;
                this.parseHttpMethodAndPath(stringArray.method(), stringArray.path(), stringArray.hasBody());
                return;
            }
            if (stringArray instanceof Headers) {
                if ((stringArray = ((Headers)stringArray).value()).length == 0) {
                    throw this.methodError("@Headers annotation is empty.", new Object[0]);
                }
                this.headers = this.parseHeaders(stringArray);
                return;
            }
            if (stringArray instanceof Multipart) {
                if (this.isFormEncoded) {
                    throw this.methodError("Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isMultipart = true;
                return;
            }
            if (stringArray instanceof FormUrlEncoded) {
                if (this.isMultipart) {
                    throw this.methodError("Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isFormEncoded = true;
            }
        }
    }

    private void parseHttpMethodAndPath(String string, String string2, boolean bl) {
        String string3;
        Matcher matcher;
        if (this.httpMethod != null) {
            throw this.methodError("Only one HTTP method is allowed. Found: %s and %s.", this.httpMethod, string);
        }
        this.httpMethod = string;
        this.hasBody = bl;
        if (string2.isEmpty()) {
            return;
        }
        int n2 = string2.indexOf(63);
        if (n2 != -1 && n2 < string2.length() - 1 && (matcher = ServiceMethod.PARAM_URL_REGEX.matcher(string3 = string2.substring(n2 + 1))).find()) {
            throw this.methodError("URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", string3);
        }
        this.relativeUrl = string2;
        this.relativeUrlParamNames = ServiceMethod.parsePathParameters(string2);
    }

    private com.zoyi.retrofit2.okhttp3.Headers parseHeaders(String[] stringArray) {
        Headers$Builder headers$Builder = new Headers$Builder();
        for (String string : stringArray) {
            int n2 = string.indexOf(58);
            if (n2 == -1 || n2 == 0 || n2 == string.length() - 1) {
                throw this.methodError("@Headers value must be in the form \"Name: Value\". Found: \"%s\"", string);
            }
            String string2 = string.substring(0, n2);
            string = string.substring(n2 + 1).trim();
            if ("Content-Type".equalsIgnoreCase(string2)) {
                MediaType mediaType = MediaType.parse(string);
                if (mediaType == null) {
                    throw this.methodError("Malformed content type: %s", string);
                }
                this.contentType = mediaType;
                continue;
            }
            headers$Builder.add(string2, string);
        }
        return headers$Builder.build();
    }

    private ParameterHandler<?> parseParameter(int n2, Type type, Annotation[] annotationArray) {
        Object object = null;
        Annotation[] annotationArray2 = annotationArray;
        int n3 = annotationArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = annotationArray2[i2];
            if ((object2 = this.parseParameterAnnotation(n2, type, annotationArray, (Annotation)object2)) == null) continue;
            if (object != null) {
                throw this.parameterError(n2, "Multiple Retrofit annotations found, only one allowed.", new Object[0]);
            }
            object = object2;
        }
        if (object == null) {
            throw this.parameterError(n2, "No Retrofit annotation found.", new Object[0]);
        }
        return object;
    }

    private ParameterHandler<?> parseParameterAnnotation(int n2, Type object, Annotation[] annotationArray, Annotation annotation) {
        if (annotation instanceof Url) {
            if (this.gotUrl) {
                throw this.parameterError(n2, "Multiple @Url method annotations found.", new Object[0]);
            }
            if (this.gotPath) {
                throw this.parameterError(n2, "@Path parameters may not be used with @Url.", new Object[0]);
            }
            if (this.gotQuery) {
                throw this.parameterError(n2, "A @Url parameter must not come after a @Query", new Object[0]);
            }
            if (this.relativeUrl != null) {
                throw this.parameterError(n2, "@Url cannot be used with @%s URL", this.httpMethod);
            }
            this.gotUrl = true;
            if (object == HttpUrl.class || object == String.class || object == URI.class || object instanceof Class && "android.net.Uri".equals(((Class)object).getName())) {
                return new ParameterHandler$RelativeUrl();
            }
            throw this.parameterError(n2, "@Url must be okhttp3.HttpUrl, String, java.net.URI, or android.net.Uri type.", new Object[0]);
        }
        if (annotation instanceof Path) {
            if (this.gotQuery) {
                throw this.parameterError(n2, "A @Path parameter must not come after a @Query.", new Object[0]);
            }
            if (this.gotUrl) {
                throw this.parameterError(n2, "@Path parameters may not be used with @Url.", new Object[0]);
            }
            if (this.relativeUrl == null) {
                throw this.parameterError(n2, "@Path can only be used with relative url on @%s", this.httpMethod);
            }
            this.gotPath = true;
            Path path = (Path)annotation;
            String string = path.value();
            this.validatePathName(n2, string);
            Converter converter = this.retrofit.stringConverter((Type)object, annotationArray);
            return new ParameterHandler$Path(string, converter, path.encoded());
        }
        if (annotation instanceof Query) {
            Object object2 = (Query)annotation;
            String string = object2.value();
            boolean bl = object2.encoded();
            object2 = Utils.getRawType((Type)object);
            this.gotQuery = true;
            if (Iterable.class.isAssignableFrom((Class<?>)object2)) {
                if (!(object instanceof ParameterizedType)) {
                    throw this.parameterError(n2, ((Class)object2).getSimpleName() + " must include generic type (e.g., " + ((Class)object2).getSimpleName() + "<String>)", new Object[0]);
                }
                object = (ParameterizedType)object;
                object = Utils.getParameterUpperBound(0, object);
                Converter converter = this.retrofit.stringConverter((Type)object, annotationArray);
                return new ParameterHandler$Query(string, converter, bl).iterable();
            }
            if (((Class)object2).isArray()) {
                object = ServiceMethod.boxIfPrimitive(((Class)object2).getComponentType());
                object = this.retrofit.stringConverter((Type)object, annotationArray);
                return new ParameterHandler$Query(string, object, bl).array();
            }
            object = this.retrofit.stringConverter((Type)object, annotationArray);
            return new ParameterHandler$Query(string, object, bl);
        }
        if (annotation instanceof QueryMap) {
            Type type = Utils.getRawType((Type)object);
            if (!Map.class.isAssignableFrom((Class<?>)type)) {
                throw this.parameterError(n2, "@QueryMap parameter type must be Map.", new Object[0]);
            }
            Type type2 = Utils.getSupertype((Type)object, type, Map.class);
            if (!(type2 instanceof ParameterizedType)) {
                throw this.parameterError(n2, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
            }
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            type = Utils.getParameterUpperBound(0, parameterizedType);
            if (String.class != type) {
                throw this.parameterError(n2, "@QueryMap keys must be of type String: " + type, new Object[0]);
            }
            object = Utils.getParameterUpperBound(1, parameterizedType);
            object = this.retrofit.stringConverter((Type)object, annotationArray);
            return new ParameterHandler$QueryMap(object, ((QueryMap)annotation).encoded());
        }
        if (annotation instanceof Header) {
            Object object3 = (Header)annotation;
            String string = object3.value();
            Class<?> clazz = Utils.getRawType((Type)object);
            if (Iterable.class.isAssignableFrom(clazz)) {
                if (!(object instanceof ParameterizedType)) {
                    throw this.parameterError(n2, clazz.getSimpleName() + " must include generic type (e.g., " + clazz.getSimpleName() + "<String>)", new Object[0]);
                }
                object3 = (ParameterizedType)object;
                object = Utils.getParameterUpperBound(0, object3);
                object = this.retrofit.stringConverter((Type)object, annotationArray);
                return new ParameterHandler$Header(string, object).iterable();
            }
            if (clazz.isArray()) {
                object3 = ServiceMethod.boxIfPrimitive(clazz.getComponentType());
                object = this.retrofit.stringConverter((Type)object3, annotationArray);
                return new ParameterHandler$Header(string, object).array();
            }
            object3 = this.retrofit.stringConverter((Type)object, annotationArray);
            return new ParameterHandler$Header(string, object3);
        }
        if (annotation instanceof HeaderMap) {
            Type type = Utils.getRawType((Type)object);
            if (!Map.class.isAssignableFrom((Class<?>)type)) {
                throw this.parameterError(n2, "@HeaderMap parameter type must be Map.", new Object[0]);
            }
            Type type3 = Utils.getSupertype((Type)object, type, Map.class);
            if (!(type3 instanceof ParameterizedType)) {
                throw this.parameterError(n2, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
            }
            ParameterizedType parameterizedType = (ParameterizedType)type3;
            type = Utils.getParameterUpperBound(0, parameterizedType);
            if (String.class != type) {
                throw this.parameterError(n2, "@HeaderMap keys must be of type String: " + type, new Object[0]);
            }
            object = Utils.getParameterUpperBound(1, parameterizedType);
            object = this.retrofit.stringConverter((Type)object, annotationArray);
            return new ParameterHandler$HeaderMap(object);
        }
        if (annotation instanceof Field) {
            if (!this.isFormEncoded) {
                throw this.parameterError(n2, "@Field parameters can only be used with form encoding.", new Object[0]);
            }
            Class<?> clazz = (Field)annotation;
            String string = clazz.value();
            boolean bl = clazz.encoded();
            this.gotField = true;
            clazz = Utils.getRawType((Type)object);
            if (Iterable.class.isAssignableFrom(clazz)) {
                if (!(object instanceof ParameterizedType)) {
                    throw this.parameterError(n2, clazz.getSimpleName() + " must include generic type (e.g., " + clazz.getSimpleName() + "<String>)", new Object[0]);
                }
                object = (ParameterizedType)object;
                object = Utils.getParameterUpperBound(0, object);
                Converter converter = this.retrofit.stringConverter((Type)object, annotationArray);
                return new ParameterHandler$Field(string, converter, bl).iterable();
            }
            if (clazz.isArray()) {
                object = ServiceMethod.boxIfPrimitive(clazz.getComponentType());
                object = this.retrofit.stringConverter((Type)object, annotationArray);
                return new ParameterHandler$Field(string, object, bl).array();
            }
            object = this.retrofit.stringConverter((Type)object, annotationArray);
            return new ParameterHandler$Field(string, object, bl);
        }
        if (annotation instanceof FieldMap) {
            if (!this.isFormEncoded) {
                throw this.parameterError(n2, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
            }
            Type type = Utils.getRawType((Type)object);
            if (!Map.class.isAssignableFrom((Class<?>)type)) {
                throw this.parameterError(n2, "@FieldMap parameter type must be Map.", new Object[0]);
            }
            Type type4 = Utils.getSupertype(object, type, Map.class);
            if (!(type4 instanceof ParameterizedType)) {
                throw this.parameterError(n2, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
            }
            ParameterizedType parameterizedType = (ParameterizedType)type4;
            type = Utils.getParameterUpperBound(0, parameterizedType);
            if (String.class != type) {
                throw this.parameterError(n2, "@FieldMap keys must be of type String: " + type, new Object[0]);
            }
            object = Utils.getParameterUpperBound(1, parameterizedType);
            object = this.retrofit.stringConverter((Type)object, annotationArray);
            this.gotField = true;
            return new ParameterHandler$FieldMap(object, ((FieldMap)annotation).encoded());
        }
        if (annotation instanceof Part) {
            if (!this.isMultipart) {
                throw this.parameterError(n2, "@Part parameters can only be used with multipart encoding.", new Object[0]);
            }
            Class<?> clazz = (Part)annotation;
            this.gotPart = true;
            String string = clazz.value();
            Class<?> clazz2 = Utils.getRawType(object);
            if (string.isEmpty()) {
                if (Iterable.class.isAssignableFrom(clazz2)) {
                    if (!(object instanceof ParameterizedType)) {
                        throw this.parameterError(n2, clazz2.getSimpleName() + " must include generic type (e.g., " + clazz2.getSimpleName() + "<String>)", new Object[0]);
                    }
                    clazz = (ParameterizedType)object;
                    if (!MultipartBody$Part.class.isAssignableFrom(Utils.getRawType(object = Utils.getParameterUpperBound(0, clazz)))) {
                        throw this.parameterError(n2, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                    }
                    return ParameterHandler$RawPart.INSTANCE.iterable();
                }
                if (clazz2.isArray()) {
                    clazz = clazz2.getComponentType();
                    if (!MultipartBody$Part.class.isAssignableFrom(clazz)) {
                        throw this.parameterError(n2, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                    }
                    return ParameterHandler$RawPart.INSTANCE.array();
                }
                if (MultipartBody$Part.class.isAssignableFrom(clazz2)) {
                    return ParameterHandler$RawPart.INSTANCE;
                }
                throw this.parameterError(n2, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
            }
            clazz = com.zoyi.retrofit2.okhttp3.Headers.of("Content-Disposition", "form-data; name=\"" + string + "\"", "Content-Transfer-Encoding", clazz.encoding());
            if (Iterable.class.isAssignableFrom(clazz2)) {
                if (!(object instanceof ParameterizedType)) {
                    throw this.parameterError(n2, clazz2.getSimpleName() + " must include generic type (e.g., " + clazz2.getSimpleName() + "<String>)", new Object[0]);
                }
                object = (ParameterizedType)object;
                if (MultipartBody$Part.class.isAssignableFrom(Utils.getRawType(object = Utils.getParameterUpperBound(0, object)))) {
                    throw this.parameterError(n2, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                }
                Converter converter = this.retrofit.requestBodyConverter((Type)object, annotationArray, this.methodAnnotations);
                return new ParameterHandler$Part((com.zoyi.retrofit2.okhttp3.Headers)((Object)clazz), converter).iterable();
            }
            if (clazz2.isArray()) {
                object = ServiceMethod.boxIfPrimitive(clazz2.getComponentType());
                if (MultipartBody$Part.class.isAssignableFrom((Class<?>)object)) {
                    throw this.parameterError(n2, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                }
                object = this.retrofit.requestBodyConverter((Type)object, annotationArray, this.methodAnnotations);
                return new ParameterHandler$Part((com.zoyi.retrofit2.okhttp3.Headers)((Object)clazz), object).array();
            }
            if (MultipartBody$Part.class.isAssignableFrom(clazz2)) {
                throw this.parameterError(n2, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
            }
            object = this.retrofit.requestBodyConverter((Type)object, annotationArray, this.methodAnnotations);
            return new ParameterHandler$Part((com.zoyi.retrofit2.okhttp3.Headers)((Object)clazz), object);
        }
        if (annotation instanceof PartMap) {
            if (!this.isMultipart) {
                throw this.parameterError(n2, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
            }
            this.gotPart = true;
            Type type = Utils.getRawType((Type)object);
            if (!Map.class.isAssignableFrom((Class<?>)type)) {
                throw this.parameterError(n2, "@PartMap parameter type must be Map.", new Object[0]);
            }
            Type type5 = Utils.getSupertype(object, type, Map.class);
            if (!(type5 instanceof ParameterizedType)) {
                throw this.parameterError(n2, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
            }
            ParameterizedType parameterizedType = (ParameterizedType)type5;
            type = Utils.getParameterUpperBound(0, parameterizedType);
            if (String.class != type) {
                throw this.parameterError(n2, "@PartMap keys must be of type String: " + type, new Object[0]);
            }
            object = Utils.getParameterUpperBound(1, parameterizedType);
            if (MultipartBody$Part.class.isAssignableFrom(Utils.getRawType((Type)object))) {
                throw this.parameterError(n2, "@PartMap values cannot be MultipartBody.Part. Use @Part List<Part> or a different value type instead.", new Object[0]);
            }
            object = this.retrofit.requestBodyConverter((Type)object, annotationArray, this.methodAnnotations);
            PartMap partMap = (PartMap)annotation;
            return new ParameterHandler$PartMap(object, partMap.encoding());
        }
        if (annotation instanceof Body) {
            Converter converter;
            if (this.isFormEncoded || this.isMultipart) {
                throw this.parameterError(n2, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
            }
            if (this.gotBody) {
                throw this.parameterError(n2, "Multiple @Body method annotations found.", new Object[0]);
            }
            try {
                converter = this.retrofit.requestBodyConverter((Type)object, annotationArray, this.methodAnnotations);
            }
            catch (RuntimeException runtimeException) {
                throw this.parameterError(runtimeException, n2, "Unable to create @Body converter for %s", object);
            }
            this.gotBody = true;
            return new ParameterHandler$Body(converter);
        }
        return null;
    }

    private void validatePathName(int n2, String string) {
        if (!ServiceMethod.PARAM_NAME_REGEX.matcher(string).matches()) {
            throw this.parameterError(n2, "@Path parameter name must match %s. Found: %s", ServiceMethod.PARAM_URL_REGEX.pattern(), string);
        }
        if (!this.relativeUrlParamNames.contains(string)) {
            throw this.parameterError(n2, "URL \"%s\" does not contain \"{%s}\".", this.relativeUrl, string);
        }
    }

    private Converter<ResponseBody, T> createResponseConverter() {
        Annotation[] annotationArray = this.method.getAnnotations();
        try {
            return this.retrofit.responseBodyConverter(this.responseType, annotationArray);
        }
        catch (RuntimeException runtimeException) {
            throw this.methodError(runtimeException, "Unable to create converter for %s", this.responseType);
        }
    }

    private RuntimeException methodError(String string, Object ... objectArray) {
        return this.methodError(null, string, objectArray);
    }

    private RuntimeException methodError(Throwable throwable, String string, Object ... objectArray) {
        string = String.format(string, objectArray);
        return new IllegalArgumentException(string + "\n    for method " + this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName(), throwable);
    }

    private RuntimeException parameterError(Throwable throwable, int n2, String string, Object ... objectArray) {
        return this.methodError(throwable, string + " (parameter #" + (n2 + 1) + ")", objectArray);
    }

    private RuntimeException parameterError(int n2, String string, Object ... objectArray) {
        return this.methodError(string + " (parameter #" + (n2 + 1) + ")", objectArray);
    }
}

