/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.BuiltInConverters$ToStringConverter;
import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.CallAdapter$Factory;
import com.zoyi.retrofit2.Converter;
import com.zoyi.retrofit2.Converter$Factory;
import com.zoyi.retrofit2.Platform;
import com.zoyi.retrofit2.Retrofit$1;
import com.zoyi.retrofit2.ServiceMethod;
import com.zoyi.retrofit2.ServiceMethod$Builder;
import com.zoyi.retrofit2.Utils;
import com.zoyi.retrofit2.okhttp3.Call$Factory;
import com.zoyi.retrofit2.okhttp3.HttpUrl;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public final class Retrofit {
    private final Map<Method, ServiceMethod> serviceMethodCache = new LinkedHashMap<Method, ServiceMethod>();
    private final Call$Factory callFactory;
    private final HttpUrl baseUrl;
    private final List<Converter$Factory> converterFactories;
    private final List<CallAdapter$Factory> adapterFactories;
    private final Executor callbackExecutor;
    private final boolean validateEagerly;

    Retrofit(Call$Factory call$Factory, HttpUrl httpUrl, List<Converter$Factory> list, List<CallAdapter$Factory> list2, Executor executor, boolean bl) {
        this.callFactory = call$Factory;
        this.baseUrl = httpUrl;
        this.converterFactories = Collections.unmodifiableList(list);
        this.adapterFactories = Collections.unmodifiableList(list2);
        this.callbackExecutor = executor;
        this.validateEagerly = bl;
    }

    public final <T> T create(Class<T> clazz) {
        Utils.validateServiceInterface(clazz);
        if (this.validateEagerly) {
            this.eagerlyValidateMethods(clazz);
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new Retrofit$1(this, clazz));
    }

    private void eagerlyValidateMethods(Class<?> methodArray) {
        Platform platform = Platform.get();
        for (Method method : methodArray.getDeclaredMethods()) {
            if (platform.isDefaultMethod(method)) continue;
            this.loadServiceMethod(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ServiceMethod loadServiceMethod(Method method) {
        ServiceMethod serviceMethod;
        Map<Method, ServiceMethod> map = this.serviceMethodCache;
        synchronized (map) {
            serviceMethod = this.serviceMethodCache.get(method);
            if (serviceMethod == null) {
                serviceMethod = new ServiceMethod$Builder(this, method).build();
                this.serviceMethodCache.put(method, serviceMethod);
            }
        }
        return serviceMethod;
    }

    public final Call$Factory callFactory() {
        return this.callFactory;
    }

    public final HttpUrl baseUrl() {
        return this.baseUrl;
    }

    public final List<CallAdapter$Factory> callAdapterFactories() {
        return this.adapterFactories;
    }

    public final CallAdapter<?> callAdapter(Type type, Annotation[] annotationArray) {
        return this.nextCallAdapter(null, type, annotationArray);
    }

    public final CallAdapter<?> nextCallAdapter(CallAdapter$Factory callAdapter$Factory, Type type, Annotation[] annotationArray) {
        int n2;
        Utils.checkNotNull(type, "returnType == null");
        Utils.checkNotNull(annotationArray, "annotations == null");
        int n3 = this.adapterFactories.size();
        for (int i2 = n2 = this.adapterFactories.indexOf(callAdapter$Factory) + 1; i2 < n3; ++i2) {
            CallAdapter<?> callAdapter = this.adapterFactories.get(i2).get(type, annotationArray, this);
            if (callAdapter == null) continue;
            return callAdapter;
        }
        StringBuilder stringBuilder = new StringBuilder("Could not locate call adapter for ").append(type).append(".\n");
        if (callAdapter$Factory != null) {
            stringBuilder.append("  Skipped:");
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuilder.append("\n   * ").append(this.adapterFactories.get(n3).getClass().getName());
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("  Tried:");
        int n4 = this.adapterFactories.size();
        for (n3 = n2; n3 < n4; ++n3) {
            stringBuilder.append("\n   * ").append(this.adapterFactories.get(n3).getClass().getName());
        }
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public final List<Converter$Factory> converterFactories() {
        return this.converterFactories;
    }

    public final <T> Converter<T, RequestBody> requestBodyConverter(Type type, Annotation[] annotationArray, Annotation[] annotationArray2) {
        return this.nextRequestBodyConverter(null, type, annotationArray, annotationArray2);
    }

    public final <T> Converter<T, RequestBody> nextRequestBodyConverter(Converter$Factory converter$Factory, Type type, Annotation[] annotationArray, Annotation[] annotationArray2) {
        int n2;
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotationArray, "parameterAnnotations == null");
        Utils.checkNotNull(annotationArray2, "methodAnnotations == null");
        int n3 = this.converterFactories.size();
        for (int i2 = n2 = this.converterFactories.indexOf(converter$Factory) + 1; i2 < n3; ++i2) {
            Object object = this.converterFactories.get(i2);
            if ((object = ((Converter$Factory)object).requestBodyConverter(type, annotationArray, annotationArray2, this)) == null) continue;
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder("Could not locate RequestBody converter for ").append(type).append(".\n");
        if (converter$Factory != null) {
            stringBuilder.append("  Skipped:");
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuilder.append("\n   * ").append(this.converterFactories.get(n3).getClass().getName());
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("  Tried:");
        int n4 = this.converterFactories.size();
        for (n3 = n2; n3 < n4; ++n3) {
            stringBuilder.append("\n   * ").append(this.converterFactories.get(n3).getClass().getName());
        }
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public final <T> Converter<ResponseBody, T> responseBodyConverter(Type type, Annotation[] annotationArray) {
        return this.nextResponseBodyConverter(null, type, annotationArray);
    }

    public final <T> Converter<ResponseBody, T> nextResponseBodyConverter(Converter$Factory converter$Factory, Type type, Annotation[] annotationArray) {
        int n2;
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotationArray, "annotations == null");
        int n3 = this.converterFactories.size();
        for (int i2 = n2 = this.converterFactories.indexOf(converter$Factory) + 1; i2 < n3; ++i2) {
            Converter<ResponseBody, ?> converter = this.converterFactories.get(i2).responseBodyConverter(type, annotationArray, this);
            if (converter == null) continue;
            return converter;
        }
        StringBuilder stringBuilder = new StringBuilder("Could not locate ResponseBody converter for ").append(type).append(".\n");
        if (converter$Factory != null) {
            stringBuilder.append("  Skipped:");
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuilder.append("\n   * ").append(this.converterFactories.get(n3).getClass().getName());
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("  Tried:");
        int n4 = this.converterFactories.size();
        for (n3 = n2; n3 < n4; ++n3) {
            stringBuilder.append("\n   * ").append(this.converterFactories.get(n3).getClass().getName());
        }
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public final <T> Converter<T, String> stringConverter(Type type, Annotation[] annotationArray) {
        Utils.checkNotNull(type, "type == null");
        Utils.checkNotNull(annotationArray, "annotations == null");
        int n2 = this.converterFactories.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Converter<?, String> converter = this.converterFactories.get(i2).stringConverter(type, annotationArray, this);
            if (converter == null) continue;
            return converter;
        }
        return BuiltInConverters$ToStringConverter.INSTANCE;
    }

    public final Executor callbackExecutor() {
        return this.callbackExecutor;
    }
}

