/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.okhttp3.Headers;
import com.zoyi.retrofit2.okhttp3.Protocol;
import com.zoyi.retrofit2.okhttp3.Request$Builder;
import com.zoyi.retrofit2.okhttp3.Response$Builder;
import com.zoyi.retrofit2.okhttp3.ResponseBody;

public final class Response<T> {
    private final com.zoyi.retrofit2.okhttp3.Response rawResponse;
    private final T body;
    private final ResponseBody errorBody;

    public static <T> Response<T> success(T t2) {
        return Response.success(t2, new Response$Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).request(new Request$Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(T t2, Headers headers) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        return Response.success(t2, new Response$Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).headers(headers).request(new Request$Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(T t2, com.zoyi.retrofit2.okhttp3.Response response) {
        if (response == null) {
            throw new NullPointerException("rawResponse == null");
        }
        if (!response.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse must be successful response");
        }
        return new Response<T>(response, t2, null);
    }

    public static <T> Response<T> error(int n2, ResponseBody responseBody) {
        if (n2 < 400) {
            throw new IllegalArgumentException("code < 400: " + n2);
        }
        return Response.error(responseBody, new Response$Builder().code(n2).protocol(Protocol.HTTP_1_1).request(new Request$Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> error(ResponseBody responseBody, com.zoyi.retrofit2.okhttp3.Response response) {
        if (responseBody == null) {
            throw new NullPointerException("body == null");
        }
        if (response == null) {
            throw new NullPointerException("rawResponse == null");
        }
        if (response.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse should not be successful response");
        }
        return new Response<Object>(response, null, responseBody);
    }

    private Response(com.zoyi.retrofit2.okhttp3.Response response, T t2, ResponseBody responseBody) {
        this.rawResponse = response;
        this.body = t2;
        this.errorBody = responseBody;
    }

    public final com.zoyi.retrofit2.okhttp3.Response raw() {
        return this.rawResponse;
    }

    public final int code() {
        return this.rawResponse.code();
    }

    public final String message() {
        return this.rawResponse.message();
    }

    public final Headers headers() {
        return this.rawResponse.headers();
    }

    public final boolean isSuccessful() {
        return this.rawResponse.isSuccessful();
    }

    public final T body() {
        return this.body;
    }

    public final ResponseBody errorBody() {
        return this.errorBody;
    }
}

