/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2;

import com.zoyi.retrofit2.Callback;
import com.zoyi.retrofit2.OkHttpCall$1;
import com.zoyi.retrofit2.OkHttpCall$ExceptionCatchingRequestBody;
import com.zoyi.retrofit2.OkHttpCall$NoContentResponseBody;
import com.zoyi.retrofit2.ServiceMethod;
import com.zoyi.retrofit2.Utils;
import com.zoyi.retrofit2.okhttp3.Call;
import com.zoyi.retrofit2.okhttp3.Request;
import com.zoyi.retrofit2.okhttp3.Response;
import com.zoyi.retrofit2.okhttp3.ResponseBody;
import java.io.IOException;

final class OkHttpCall<T>
implements com.zoyi.retrofit2.Call<T> {
    private final ServiceMethod<T> serviceMethod;
    private final Object[] args;
    private volatile boolean canceled;
    private Call rawCall;
    private Throwable creationFailure;
    private boolean executed;

    OkHttpCall(ServiceMethod<T> serviceMethod, Object[] objectArray) {
        this.serviceMethod = serviceMethod;
        this.args = objectArray;
    }

    @Override
    public final OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.serviceMethod, this.args);
    }

    @Override
    public final synchronized Request request() {
        Call call = this.rawCall;
        if (call != null) {
            return call.request();
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw new RuntimeException("Unable to create request.", this.creationFailure);
            }
            throw (RuntimeException)this.creationFailure;
        }
        try {
            this.rawCall = this.createRawCall();
            return this.rawCall.request();
        }
        catch (RuntimeException runtimeException) {
            this.creationFailure = runtimeException;
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.creationFailure = iOException;
            throw new RuntimeException("Unable to create request.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enqueue(Callback<T> callback) {
        Throwable throwable;
        Call call;
        if (callback == null) {
            throw new NullPointerException("callback == null");
        }
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.rawCall;
            throwable = this.creationFailure;
            if (call == null && throwable == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (Throwable throwable2) {
                    throwable = this.creationFailure = throwable2;
                }
            }
        }
        if (throwable != null) {
            callback.onFailure(this, throwable);
            return;
        }
        if (this.canceled) {
            call.cancel();
        }
        call.enqueue(new OkHttpCall$1(this, callback));
    }

    @Override
    public final synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final com.zoyi.retrofit2.Response<T> execute() throws IOException {
        Call call;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            if (this.creationFailure != null) {
                if (this.creationFailure instanceof IOException) {
                    throw (IOException)this.creationFailure;
                }
                throw (RuntimeException)this.creationFailure;
            }
            call = this.rawCall;
            if (call == null) {
                try {
                    call = this.rawCall = this.createRawCall();
                }
                catch (IOException | RuntimeException exception) {
                    this.creationFailure = exception;
                    throw exception;
                }
            }
        }
        if (this.canceled) {
            call.cancel();
        }
        return this.parseResponse(call.execute());
    }

    private Call createRawCall() throws IOException {
        Object object = this.serviceMethod.toRequest(this.args);
        if ((object = this.serviceMethod.callFactory.newCall((Request)object)) == null) {
            throw new NullPointerException("Call.Factory returned null.");
        }
        return object;
    }

    final com.zoyi.retrofit2.Response<T> parseResponse(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        int n2 = (response = response.newBuilder().body(new OkHttpCall$NoContentResponseBody(responseBody.contentType(), responseBody.contentLength())).build()).code();
        if (n2 < 200 || n2 >= 300) {
            try {
                ResponseBody responseBody2 = Utils.buffer(responseBody);
                com.zoyi.retrofit2.Response response2 = com.zoyi.retrofit2.Response.error(responseBody2, response);
                return response2;
            }
            finally {
                responseBody.close();
            }
        }
        if (n2 == 204 || n2 == 205) {
            return com.zoyi.retrofit2.Response.success(null, response);
        }
        OkHttpCall$ExceptionCatchingRequestBody okHttpCall$ExceptionCatchingRequestBody = new OkHttpCall$ExceptionCatchingRequestBody(responseBody);
        try {
            T t2 = this.serviceMethod.toResponse(okHttpCall$ExceptionCatchingRequestBody);
            return com.zoyi.retrofit2.Response.success(t2, response);
        }
        catch (RuntimeException runtimeException) {
            okHttpCall$ExceptionCatchingRequestBody.throwIfCaught();
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        Call call;
        this.canceled = true;
        OkHttpCall okHttpCall = this;
        synchronized (okHttpCall) {
            call = this.rawCall;
        }
        if (call != null) {
            call.cancel();
        }
    }

    @Override
    public final boolean isCanceled() {
        return this.canceled;
    }
}

