/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.utf8;

import com.zoyi.io.socket.utf8.UTF8Exception;
import java.util.ArrayList;
import java.util.List;

public final class UTF8 {
    private static final String INVALID_CONTINUATION_BYTE = "Invalid continuation byte";
    private static int[] byteArray;
    private static int byteCount;
    private static int byteIndex;

    private UTF8() {
    }

    public static String encode(String object) throws UTF8Exception {
        int[] nArray = UTF8.ucs2decode((String)object);
        object = nArray;
        int n2 = nArray.length;
        int n3 = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while (++n3 < n2) {
            Object object2 = object[n3];
            stringBuilder.append(UTF8.encodeCodePoint((int)object2));
        }
        return stringBuilder.toString();
    }

    public static String decode(String object) throws UTF8Exception {
        int n2;
        byteArray = UTF8.ucs2decode((String)object);
        byteCount = byteArray.length;
        byteIndex = 0;
        object = new ArrayList();
        while ((n2 = UTF8.decodeSymbol()) != -1) {
            object.add(n2);
        }
        return UTF8.ucs2encode(UTF8.listToArray((List<Integer>)object));
    }

    private static int[] ucs2decode(String string) {
        int n2;
        int n3 = string.length();
        int[] nArray = new int[string.codePointCount(0, n3)];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            nArray[n4++] = n2;
        }
        return nArray;
    }

    private static String encodeCodePoint(int n2) throws UTF8Exception {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n2 & 0xFFFFFF80) == 0) {
            return stringBuilder.append(Character.toChars(n2)).toString();
        }
        if ((n2 & 0xFFFFF800) == 0) {
            stringBuilder.append(Character.toChars(n2 >> 6 & 0x1F | 0xC0));
        } else if ((n2 & 0xFFFF0000) == 0) {
            UTF8.checkScalarValue(n2);
            stringBuilder.append(Character.toChars(n2 >> 12 & 0xF | 0xE0));
            stringBuilder.append(UTF8.createByte(n2, 6));
        } else if ((n2 & 0xFFE00000) == 0) {
            stringBuilder.append(Character.toChars(n2 >> 18 & 7 | 0xF0));
            stringBuilder.append(UTF8.createByte(n2, 12));
            stringBuilder.append(UTF8.createByte(n2, 6));
        }
        stringBuilder.append(Character.toChars(n2 & 0x3F | 0x80));
        return stringBuilder.toString();
    }

    private static char[] createByte(int n2, int n3) {
        return Character.toChars(n2 >> n3 & 0x3F | 0x80);
    }

    private static int decodeSymbol() throws UTF8Exception {
        int n2;
        int n3;
        int n4;
        if (byteIndex > byteCount) {
            throw new UTF8Exception("Invalid byte index");
        }
        if (byteIndex == byteCount) {
            return -1;
        }
        int n5 = byteArray[byteIndex] & 0xFF;
        ++byteIndex;
        if ((n5 & 0x80) == 0) {
            return n5;
        }
        if ((n5 & 0xE0) == 192) {
            int n6 = UTF8.readContinuationByte();
            if ((n5 = (n5 & 0x1F) << 6 | n6) >= 128) {
                return n5;
            }
            throw new UTF8Exception(INVALID_CONTINUATION_BYTE);
        }
        if ((n5 & 0xF0) == 224) {
            int n7;
            int n8 = UTF8.readContinuationByte();
            if ((n5 = (n5 & 0xF) << 12 | n8 << 6 | (n7 = UTF8.readContinuationByte())) >= 2048) {
                UTF8.checkScalarValue(n5);
                return n5;
            }
            throw new UTF8Exception(INVALID_CONTINUATION_BYTE);
        }
        if ((n5 & 0xF8) == 240 && (n5 = (n5 & 0xF) << 18 | (n4 = UTF8.readContinuationByte()) << 12 | (n3 = UTF8.readContinuationByte()) << 6 | (n2 = UTF8.readContinuationByte())) >= 65536 && n5 <= 0x10FFFF) {
            return n5;
        }
        throw new UTF8Exception(INVALID_CONTINUATION_BYTE);
    }

    private static int readContinuationByte() throws UTF8Exception {
        if (byteIndex >= byteCount) {
            throw new UTF8Exception("Invalid byte index");
        }
        int n2 = byteArray[byteIndex] & 0xFF;
        ++byteIndex;
        if ((n2 & 0xC0) == 128) {
            return n2 & 0x3F;
        }
        throw new UTF8Exception(INVALID_CONTINUATION_BYTE);
    }

    private static String ucs2encode(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : nArray) {
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    private static void checkScalarValue(int n2) throws UTF8Exception {
        if (n2 >= 55296 && n2 <= 57343) {
            throw new UTF8Exception("Lone surrogate U+" + Integer.toHexString(n2).toUpperCase() + " is not a scalar value");
        }
    }

    private static int[] listToArray(List<Integer> list) {
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = list.get(i2);
        }
        return nArray;
    }
}

