/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okio;

import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.ForwardingSource;
import com.zoyi.io.socket.okio.Segment;
import com.zoyi.io.socket.okio.Source;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;
    private final Mac mac;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    public static HashingSource hmacSha1(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA1");
    }

    public static HashingSource hmacSha256(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA256");
    }

    private HashingSource(Source source, String string) {
        super(source);
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSource(Source source, ByteString byteString, String string) {
        super(source);
        try {
            this.mac = Mac.getInstance(string);
            this.mac.init(new SecretKeySpec(byteString.toByteArray(), string));
            this.messageDigest = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        long l3 = super.read(buffer, l2);
        if (l3 != -1L) {
            long l4;
            long l5 = buffer.size - l3;
            Segment segment = buffer.head;
            for (l4 = buffer.size; l4 > l5; l4 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
            while (l4 < buffer.size) {
                int n2 = (int)((long)segment.pos + l5 - l4);
                if (this.messageDigest != null) {
                    this.messageDigest.update(segment.data, n2, segment.limit - n2);
                } else {
                    this.mac.update(segment.data, n2, segment.limit - n2);
                }
                l5 = l4 += (long)(segment.limit - segment.pos);
                segment = segment.next;
            }
        }
        return l3;
    }

    public final ByteString hash() {
        byte[] byArray = this.messageDigest != null ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(byArray);
    }
}

