/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.platform;

import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.internal.platform.AndroidPlatform;
import com.zoyi.io.socket.okhttp3.internal.platform.Jdk9Platform;
import com.zoyi.io.socket.okhttp3.internal.platform.JdkWithJettyBootPlatform;
import com.zoyi.io.socket.okhttp3.internal.tls.BasicCertificateChainCleaner;
import com.zoyi.io.socket.okhttp3.internal.tls.CertificateChainCleaner;
import com.zoyi.io.socket.okhttp3.internal.tls.TrustRootIndex;
import com.zoyi.io.socket.okio.Buffer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        try {
            Class<?> clazz = Class.forName("sun.security.ssl.SSLContextImpl");
            sSLSocketFactory = Platform.readFieldOrNull(sSLSocketFactory, clazz, "context");
            if (sSLSocketFactory == null) {
                return null;
            }
            return Platform.readFieldOrNull(sSLSocketFactory, X509TrustManager.class, "trustManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<Protocol> list) {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        socket.connect(inetSocketAddress, n2);
    }

    public void log(int n2, String string, Throwable throwable) {
        Level level = n2 == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string, throwable);
    }

    public boolean isCleartextTrafficPermitted(String string) {
        return true;
    }

    public Object getStackTraceForCloseable(String string) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string);
        }
        return null;
    }

    public void logCloseableLeak(String string, Object object) {
        if (object == null) {
            string = string + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log(5, string, (Throwable)object);
    }

    public static List<String> alpnProtocolNames(List<Protocol> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.HTTP_1_0) continue;
            arrayList.add(protocol.toString());
        }
        return arrayList;
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(TrustRootIndex.get(x509TrustManager));
    }

    private static Platform findPlatform() {
        Platform platform = AndroidPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = Jdk9Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = JdkWithJettyBootPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> list) {
        Buffer buffer = new Buffer();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer.writeByte(protocol.toString().length());
            buffer.writeUtf8(protocol.toString());
        }
        return buffer.readByteArray();
    }

    static <T> T readFieldOrNull(Object object, Class<T> clazz, String string) {
        while (true) {
            Object object2;
            for (object2 = object.getClass(); object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
                try {
                    Object object3 = ((Class)object2).getDeclaredField(string);
                    ((Field)object3).setAccessible(true);
                    object3 = ((Field)object3).get(object);
                    if (object3 == null || !clazz.isInstance(object3)) {
                        return null;
                    }
                    return clazz.cast(object3);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError();
                }
            }
            if (string.equals("delegate") || (object2 = Platform.readFieldOrNull(object, Object.class, "delegate")) == null) break;
            object = object2;
        }
        return null;
    }
}

