/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class OptionalMethod<T> {
    private final Class<?> returnType;
    private final String methodName;
    private final Class[] methodParams;

    public OptionalMethod(Class<?> clazz, String string, Class ... classArray) {
        this.returnType = clazz;
        this.methodName = string;
        this.methodParams = classArray;
    }

    public boolean isSupported(T t2) {
        return this.getMethod(t2.getClass()) != null;
    }

    public Object invokeOptional(T t2, Object ... objectArray) throws InvocationTargetException {
        Method method = this.getMethod(t2.getClass());
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(t2, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Object invokeOptionalWithoutCheckedException(T object, Object ... object2) {
        try {
            return this.invokeOptional(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException;
            object = invocationTargetException.getTargetException();
            if (object instanceof RuntimeException) {
                throw (RuntimeException)object;
            }
            object2 = new AssertionError((Object)"Unexpected exception");
            object2.initCause((Throwable)object);
            throw object2;
        }
    }

    public Object invoke(T t2, Object ... object) throws InvocationTargetException {
        Method method = this.getMethod(t2.getClass());
        if (method == null) {
            throw new AssertionError((Object)("Method " + this.methodName + " not supported for object " + t2));
        }
        try {
            return method.invoke(t2, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            object = new AssertionError((Object)("Unexpectedly could not call: " + method));
            object.initCause(illegalAccessException);
            throw object;
        }
    }

    public Object invokeWithoutCheckedException(T object, Object ... object2) {
        try {
            return this.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException;
            object = invocationTargetException.getTargetException();
            if (object instanceof RuntimeException) {
                throw (RuntimeException)object;
            }
            object2 = new AssertionError((Object)"Unexpected exception");
            object2.initCause((Throwable)object);
            throw object2;
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = null;
        if (this.methodName != null && (method = OptionalMethod.getPublicMethod(clazz, this.methodName, this.methodParams)) != null && this.returnType != null && !this.returnType.isAssignableFrom(method.getReturnType())) {
            method = null;
        }
        return method;
    }

    private static Method getPublicMethod(Class<?> clazz, String string, Class[] classArray) {
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
            if ((method.getModifiers() & 1) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return method;
    }
}

