/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import java.util.Arrays;

public final class Settings {
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    static final int HEADER_TABLE_SIZE = 1;
    static final int ENABLE_PUSH = 2;
    static final int MAX_CONCURRENT_STREAMS = 4;
    static final int MAX_FRAME_SIZE = 5;
    static final int MAX_HEADER_LIST_SIZE = 6;
    static final int INITIAL_WINDOW_SIZE = 7;
    static final int COUNT = 10;
    private int set;
    private final int[] values = new int[10];

    final void clear() {
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    final Settings set(int n2, int n3) {
        if (n2 >= this.values.length) {
            return this;
        }
        int n4 = 1 << n2;
        this.set |= n4;
        this.values[n2] = n3;
        return this;
    }

    final boolean isSet(int n2) {
        return (this.set & (n2 = 1 << n2)) != 0;
    }

    final int get(int n2) {
        return this.values[n2];
    }

    final int size() {
        return Integer.bitCount(this.set);
    }

    final int getHeaderTableSize() {
        if ((2 & this.set) != 0) {
            return this.values[1];
        }
        return -1;
    }

    final boolean getEnablePush(boolean bl) {
        return ((4 & this.set) != 0 ? this.values[2] : (bl ? 1 : 0)) == 1;
    }

    final int getMaxConcurrentStreams(int n2) {
        if ((0x10 & this.set) != 0) {
            return this.values[4];
        }
        return n2;
    }

    final int getMaxFrameSize(int n2) {
        if ((0x20 & this.set) != 0) {
            return this.values[5];
        }
        return n2;
    }

    final int getMaxHeaderListSize(int n2) {
        if ((0x40 & this.set) != 0) {
            return this.values[6];
        }
        return n2;
    }

    final int getInitialWindowSize() {
        if ((0x80 & this.set) != 0) {
            return this.values[7];
        }
        return 65535;
    }

    final void merge(Settings settings) {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!settings.isSet(i2)) continue;
            this.set(i2, settings.get(i2));
        }
    }
}

