/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Connection;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream$FramedDataSink;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream$FramedDataSource;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Stream$StreamTimeout;
import com.zoyi.io.socket.okhttp3.internal.http2.StreamResetException;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Sink;
import com.zoyi.io.socket.okio.Source;
import com.zoyi.io.socket.okio.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;

public final class Http2Stream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final int id;
    final Http2Connection connection;
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    private final Http2Stream$FramedDataSource source;
    final Http2Stream$FramedDataSink sink;
    final Http2Stream$StreamTimeout readTimeout = new Http2Stream$StreamTimeout(this);
    final Http2Stream$StreamTimeout writeTimeout = new Http2Stream$StreamTimeout(this);
    ErrorCode errorCode = null;

    Http2Stream(int n2, Http2Connection http2Connection, boolean bl, boolean bl2, List<Header> list) {
        if (http2Connection == null) {
            throw new NullPointerException("connection == null");
        }
        if (list == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = n2;
        this.connection = http2Connection;
        this.bytesLeftInWriteWindow = http2Connection.peerSettings.getInitialWindowSize();
        this.source = new Http2Stream$FramedDataSource(this, http2Connection.okHttpSettings.getInitialWindowSize());
        this.sink = new Http2Stream$FramedDataSink(this);
        this.source.finished = bl2;
        this.sink.finished = bl;
        this.requestHeaders = list;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || this.responseHeaders == null;
    }

    public final boolean isLocallyInitiated() {
        boolean bl;
        boolean bl2 = bl = (this.id & 1) == 1;
        return this.connection.client == bl;
    }

    public final Http2Connection getConnection() {
        return this.connection;
    }

    public final List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public final synchronized List<Header> getResponseHeaders() throws IOException {
        this.readTimeout.enter();
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (this.responseHeaders != null) {
            return this.responseHeaders;
        }
        throw new StreamResetException(this.errorCode);
    }

    public final synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reply(List<Header> list, boolean bl) throws IOException {
        assert (!Thread.holdsLock(this));
        boolean bl2 = false;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (list == null) {
                throw new NullPointerException("responseHeaders == null");
            }
            if (this.responseHeaders != null) {
                throw new IllegalStateException("reply already sent");
            }
            this.responseHeaders = list;
            if (!bl) {
                this.sink.finished = true;
                bl2 = true;
            }
        }
        this.connection.writeSynReply(this.id, bl2, list);
        if (bl2) {
            this.connection.flush();
        }
    }

    public final Timeout readTimeout() {
        return this.readTimeout;
    }

    public final Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public final Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.responseHeaders == null && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.sink;
    }

    public final void close(ErrorCode errorCode) throws IOException {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, errorCode);
    }

    public final void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveHeaders(List<Header> list) {
        assert (!Thread.holdsLock(this));
        boolean bl = true;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.responseHeaders == null) {
                this.responseHeaders = list;
                bl = this.isOpen();
                this.notifyAll();
            } else {
                ArrayList<Header> arrayList = new ArrayList<Header>();
                arrayList.addAll(this.responseHeaders);
                arrayList.addAll(list);
                this.responseHeaders = arrayList;
            }
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final void receiveData(BufferedSource bufferedSource, int n2) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(bufferedSource, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void receiveFin() {
        boolean bl;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.source.finished = true;
            bl = this.isOpen();
            this.notifyAll();
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cancelStreamIfNecessary() throws IOException {
        boolean bl;
        boolean bl2;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            bl2 = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
            bl = this.isOpen();
        }
        if (bl2) {
            this.close(ErrorCode.CANCEL);
            return;
        }
        if (!bl) {
            this.connection.removeStream(this.id);
        }
    }

    final void addBytesToWriteWindow(long l2) {
        this.bytesLeftInWriteWindow += l2;
        if (l2 > 0L) {
            this.notifyAll();
        }
    }

    final void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException("stream closed");
        }
        if (this.sink.finished) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw new StreamResetException(this.errorCode);
        }
    }

    final void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }
}

