/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.http2.Http2;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Reader;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.Source;
import com.zoyi.io.socket.okio.Timeout;
import java.io.IOException;
import java.util.logging.Level;

final class Http2Reader$ContinuationSource
implements Source {
    private final BufferedSource source;
    int length;
    byte flags;
    int streamId;
    int left;
    short padding;

    public Http2Reader$ContinuationSource(BufferedSource bufferedSource) {
        this.source = bufferedSource;
    }

    @Override
    public final long read(Buffer buffer, long l2) throws IOException {
        while (this.left == 0) {
            this.source.skip(this.padding);
            this.padding = 0;
            if ((this.flags & 4) != 0) {
                return -1L;
            }
            this.readContinuationHeader();
        }
        long l3 = this.source.read(buffer, Math.min(l2, (long)this.left));
        if (l3 == -1L) {
            return -1L;
        }
        this.left = (int)((long)this.left - l3);
        return l3;
    }

    @Override
    public final Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public final void close() throws IOException {
    }

    private void readContinuationHeader() throws IOException {
        int n2 = this.streamId;
        this.length = this.left = Http2Reader.readMedium(this.source);
        byte by = this.source.readByte();
        this.flags = this.source.readByte();
        if (Http2Reader.logger.isLoggable(Level.FINE)) {
            Http2Reader.logger.fine(Http2.frameLog(true, this.streamId, this.length, by, this.flags));
        }
        this.streamId = this.source.readInt() & Integer.MAX_VALUE;
        if (by != 9) {
            throw Http2.ioException("%s != TYPE_CONTINUATION", by);
        }
        if (this.streamId != n2) {
            throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
        }
    }
}

