/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.http2;

import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http2.Header;
import com.zoyi.io.socket.okhttp3.internal.http2.Hpack;
import com.zoyi.io.socket.okhttp3.internal.http2.Huffman;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.ByteString;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

final class Hpack$Writer {
    private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
    private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
    private final Buffer out;
    private final boolean useCompression;
    private int smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
    private boolean emitDynamicTableSizeUpdate;
    int headerTableSizeSetting;
    int maxDynamicTableByteCount;
    Header[] dynamicTable = new Header[8];
    int nextHeaderIndex = this.dynamicTable.length - 1;
    int headerCount = 0;
    int dynamicTableByteCount = 0;

    Hpack$Writer(Buffer buffer) {
        this(4096, true, buffer);
    }

    Hpack$Writer(int n2, boolean bl, Buffer buffer) {
        this.headerTableSizeSetting = n2;
        this.maxDynamicTableByteCount = n2;
        this.useCompression = bl;
        this.out = buffer;
    }

    private void clearDynamicTable() {
        Arrays.fill(this.dynamicTable, null);
        this.nextHeaderIndex = this.dynamicTable.length - 1;
        this.headerCount = 0;
        this.dynamicTableByteCount = 0;
    }

    private int evictToRecoverBytes(int n2) {
        int n3 = 0;
        if (n2 > 0) {
            for (int i2 = this.dynamicTable.length - 1; i2 >= this.nextHeaderIndex && n2 > 0; --i2) {
                n2 -= this.dynamicTable[i2].hpackSize;
                this.dynamicTableByteCount -= this.dynamicTable[i2].hpackSize;
                --this.headerCount;
                ++n3;
            }
            System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + n3, this.headerCount);
            Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + n3, null);
            this.nextHeaderIndex += n3;
        }
        return n3;
    }

    private void insertIntoDynamicTable(Header header) {
        int n2 = header.hpackSize;
        if (n2 > this.maxDynamicTableByteCount) {
            this.clearDynamicTable();
            return;
        }
        int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
        this.evictToRecoverBytes(n3);
        if (this.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray = new Header[this.dynamicTable.length << 1];
            System.arraycopy(this.dynamicTable, 0, headerArray, this.dynamicTable.length, this.dynamicTable.length);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        n3 = this.nextHeaderIndex--;
        this.dynamicTable[n3] = header;
        ++this.headerCount;
        this.dynamicTableByteCount += n2;
    }

    final void writeHeaders(List<Header> list) throws IOException {
        if (this.emitDynamicTableSizeUpdate) {
            if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                this.writeInt(this.smallestHeaderTableSizeSetting, 31, 32);
            }
            this.emitDynamicTableSizeUpdate = false;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.writeInt(this.maxDynamicTableByteCount, 31, 32);
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Header header = list.get(i2);
            ByteString byteString = header.name.toAsciiLowercase();
            ByteString byteString2 = header.value;
            int n3 = -1;
            int n4 = -1;
            Integer n5 = Hpack.NAME_TO_FIRST_INDEX.get(byteString);
            if (n5 != null && (n4 = n5 + 1) > 1 && n4 < 8) {
                if (Util.equal(Hpack.STATIC_HEADER_TABLE[n4 - 1].value, byteString2)) {
                    n3 = n4;
                } else if (Util.equal(Hpack.STATIC_HEADER_TABLE[n4].value, byteString2)) {
                    n3 = n4 + 1;
                }
            }
            if (n3 == -1) {
                int n6 = this.dynamicTable.length;
                for (int i3 = this.nextHeaderIndex + 1; i3 < n6; ++i3) {
                    if (!Util.equal(this.dynamicTable[i3].name, byteString)) continue;
                    if (Util.equal(this.dynamicTable[i3].value, byteString2)) {
                        n3 = i3 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                        break;
                    }
                    if (n4 != -1) continue;
                    n4 = i3 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                }
            }
            if (n3 != -1) {
                this.writeInt(n3, 127, 128);
                continue;
            }
            if (n4 == -1) {
                this.out.writeByte(64);
                this.writeByteString(byteString);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
                continue;
            }
            if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(byteString)) {
                this.writeInt(n4, 15, 0);
                this.writeByteString(byteString2);
                continue;
            }
            this.writeInt(n4, 63, 64);
            this.writeByteString(byteString2);
            this.insertIntoDynamicTable(header);
        }
    }

    final void writeInt(int n2, int n3, int n4) {
        if (n2 < n3) {
            this.out.writeByte(n4 | n2);
            return;
        }
        this.out.writeByte(n4 | n3);
        n2 -= n3;
        while (n2 >= 128) {
            n3 = n2 & 0x7F;
            this.out.writeByte(n3 | 0x80);
            n2 >>>= 7;
        }
        this.out.writeByte(n2);
    }

    final void writeByteString(ByteString byteString) throws IOException {
        if (this.useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
            Buffer buffer = new Buffer();
            Huffman.get().encode(byteString, buffer);
            byteString = buffer.readByteString();
            this.writeInt(byteString.size(), 127, 128);
            this.out.write(byteString);
            return;
        }
        this.writeInt(byteString.size(), 127, 0);
        this.out.write(byteString);
    }

    final void setHeaderTableSizeSetting(int n2) {
        this.headerTableSizeSetting = n2;
        if (this.maxDynamicTableByteCount == (n2 = Math.min(n2, 16384))) {
            return;
        }
        if (n2 < this.maxDynamicTableByteCount) {
            this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n2);
        }
        this.emitDynamicTableSizeUpdate = true;
        this.maxDynamicTableByteCount = n2;
        this.adjustDynamicTableByteCount();
    }

    private void adjustDynamicTableByteCount() {
        if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
            if (this.maxDynamicTableByteCount == 0) {
                this.clearDynamicTable();
                return;
            }
            this.evictToRecoverBytes(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
        }
    }
}

