/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.connection;

import com.zoyi.io.socket.okhttp3.Address;
import com.zoyi.io.socket.okhttp3.ConnectionPool;
import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.Route;
import com.zoyi.io.socket.okhttp3.internal.Internal;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.connection.RealConnection;
import com.zoyi.io.socket.okhttp3.internal.connection.RouteDatabase;
import com.zoyi.io.socket.okhttp3.internal.connection.RouteException;
import com.zoyi.io.socket.okhttp3.internal.connection.RouteSelector;
import com.zoyi.io.socket.okhttp3.internal.connection.StreamAllocation$StreamAllocationReference;
import com.zoyi.io.socket.okhttp3.internal.http.HttpCodec;
import com.zoyi.io.socket.okhttp3.internal.http1.Http1Codec;
import com.zoyi.io.socket.okhttp3.internal.http2.ConnectionShutdownException;
import com.zoyi.io.socket.okhttp3.internal.http2.ErrorCode;
import com.zoyi.io.socket.okhttp3.internal.http2.Http2Codec;
import com.zoyi.io.socket.okhttp3.internal.http2.StreamResetException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.concurrent.TimeUnit;

public final class StreamAllocation {
    public final Address address;
    private Route route;
    private final ConnectionPool connectionPool;
    private final Object callStackTrace;
    private final RouteSelector routeSelector;
    private int refusedStreamCount;
    private RealConnection connection;
    private boolean released;
    private boolean canceled;
    private HttpCodec codec;

    public StreamAllocation(ConnectionPool connectionPool, Address address, Object object) {
        this.connectionPool = connectionPool;
        this.address = address;
        this.routeSelector = new RouteSelector(address, this.routeDatabase());
        this.callStackTrace = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpCodec newStream(OkHttpClient object, boolean bl) {
        int n2 = ((OkHttpClient)object).connectTimeoutMillis();
        int n3 = ((OkHttpClient)object).readTimeoutMillis();
        int n4 = ((OkHttpClient)object).writeTimeoutMillis();
        boolean bl2 = ((OkHttpClient)object).retryOnConnectionFailure();
        try {
            Object object2 = this.findHealthyConnection(n2, n3, n4, bl2, bl);
            if (((RealConnection)object2).http2Connection != null) {
                object = new Http2Codec((OkHttpClient)object, this, ((RealConnection)object2).http2Connection);
            } else {
                ((RealConnection)object2).socket().setSoTimeout(n3);
                ((RealConnection)object2).source.timeout().timeout(n3, TimeUnit.MILLISECONDS);
                ((RealConnection)object2).sink.timeout().timeout(n4, TimeUnit.MILLISECONDS);
                object = new Http1Codec((OkHttpClient)object, this, ((RealConnection)object2).source, ((RealConnection)object2).sink);
            }
            object2 = this.connectionPool;
            synchronized (object2) {
                this.codec = object;
                return object;
            }
        }
        catch (IOException iOException) {
            throw new RouteException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findHealthyConnection(int n2, int n3, int n4, boolean bl, boolean bl2) throws IOException {
        RealConnection realConnection;
        while (true) {
            realConnection = this.findConnection(n2, n3, n4, bl);
            ConnectionPool connectionPool = this.connectionPool;
            synchronized (connectionPool) {
                if (realConnection.successCount == 0) {
                    return realConnection;
                }
            }
            if (realConnection.isHealthy(bl2)) break;
            this.noNewStreams();
        }
        return realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RealConnection findConnection(int n2, int n3, int n4, boolean bl) throws IOException {
        Object object;
        Object object2 = this.connectionPool;
        synchronized (object2) {
            if (this.released) {
                throw new IllegalStateException("released");
            }
            if (this.codec != null) {
                throw new IllegalStateException("codec != null");
            }
            if (this.canceled) {
                throw new IOException("Canceled");
            }
            object = this.connection;
            if (object != null && !((RealConnection)object).noNewStreams) {
                return object;
            }
            object = Internal.instance.get(this.connectionPool, this.address, this);
            if (object != null) {
                this.connection = object;
                return object;
            }
            object = this.route;
        }
        if (object == null) {
            object = this.routeSelector.next();
            object2 = this.connectionPool;
            synchronized (object2) {
                this.route = object;
                this.refusedStreamCount = 0;
            }
        }
        object2 = new RealConnection((Route)object);
        object = this.connectionPool;
        synchronized (object) {
            this.acquire((RealConnection)object2);
            Internal.instance.put(this.connectionPool, (RealConnection)object2);
            this.connection = object2;
            if (this.canceled) {
                throw new IOException("Canceled");
            }
        }
        ((RealConnection)object2).connect(n2, n3, n4, this.address.connectionSpecs(), bl);
        this.routeDatabase().connected(((RealConnection)object2).route());
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamFinished(boolean bl, HttpCodec httpCodec) {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (httpCodec == null || httpCodec != this.codec) {
                throw new IllegalStateException("expected " + this.codec + " but was " + httpCodec);
            }
            if (!bl) {
                ++this.connection.successCount;
            }
        }
        this.deallocate(bl, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpCodec codec() {
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            return this.codec;
        }
    }

    private RouteDatabase routeDatabase() {
        return Internal.instance.routeDatabase(this.connectionPool);
    }

    public final synchronized RealConnection connection() {
        return this.connection;
    }

    public final void release() {
        this.deallocate(false, true, false);
    }

    public final void noNewStreams() {
        this.deallocate(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate(boolean bl, boolean bl2, boolean bl3) {
        RealConnection realConnection = null;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (bl3) {
                this.codec = null;
            }
            if (bl2) {
                this.released = true;
            }
            if (this.connection != null) {
                if (bl) {
                    this.connection.noNewStreams = true;
                }
                if (this.codec == null && (this.released || this.connection.noNewStreams)) {
                    this.release(this.connection);
                    if (this.connection.allocations.isEmpty()) {
                        this.connection.idleAtNanos = System.nanoTime();
                        if (Internal.instance.connectionBecameIdle(this.connectionPool, this.connection)) {
                            realConnection = this.connection;
                        }
                    }
                    this.connection = null;
                }
            }
        }
        if (realConnection != null) {
            Util.closeQuietly(realConnection.socket());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        RealConnection realConnection;
        HttpCodec httpCodec;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            this.canceled = true;
            httpCodec = this.codec;
            realConnection = this.connection;
        }
        if (httpCodec != null) {
            httpCodec.cancel();
            return;
        }
        if (realConnection != null) {
            realConnection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamFailed(IOException iOException) {
        boolean bl = false;
        ConnectionPool connectionPool = this.connectionPool;
        synchronized (connectionPool) {
            if (iOException instanceof StreamResetException) {
                iOException = (StreamResetException)iOException;
                if (((StreamResetException)iOException).errorCode == ErrorCode.REFUSED_STREAM) {
                    ++this.refusedStreamCount;
                }
                if (((StreamResetException)iOException).errorCode != ErrorCode.REFUSED_STREAM || this.refusedStreamCount > 1) {
                    bl = true;
                    this.route = null;
                }
            } else if (this.connection != null && !this.connection.isMultiplexed() || iOException instanceof ConnectionShutdownException) {
                bl = true;
                if (this.connection.successCount == 0) {
                    if (this.route != null && iOException != null) {
                        this.routeSelector.connectFailed(this.route, iOException);
                    }
                    this.route = null;
                }
            }
        }
        this.deallocate(bl, false, true);
    }

    public final void acquire(RealConnection realConnection) {
        assert (Thread.holdsLock(this.connectionPool));
        realConnection.allocations.add(new StreamAllocation$StreamAllocationReference(this, this.callStackTrace));
    }

    private void release(RealConnection realConnection) {
        int n2 = realConnection.allocations.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Reference<StreamAllocation> reference = realConnection.allocations.get(i2);
            if (reference.get() != this) continue;
            realConnection.allocations.remove(i2);
            return;
        }
        throw new IllegalStateException();
    }

    public final boolean hasMoreRoutes() {
        return this.route != null || this.routeSelector.hasNext();
    }

    public final String toString() {
        return this.address.toString();
    }
}

