/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache2;

import com.zoyi.io.socket.okio.Buffer;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class FileOperator {
    private static final int BUFFER_SIZE = 8192;
    private final byte[] byteArray = new byte[8192];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);
    private final FileChannel fileChannel;

    public FileOperator(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public final void write(long l2, Buffer buffer, long l3) throws IOException {
        if (l3 < 0L || l3 > buffer.size()) {
            throw new IndexOutOfBoundsException();
        }
        while (l3 > 0L) {
            try {
                int n2 = (int)Math.min(8192L, l3);
                buffer.read(this.byteArray, 0, n2);
                this.byteBuffer.limit(n2);
                do {
                    int n3 = this.fileChannel.write(this.byteBuffer, l2);
                    l2 += (long)n3;
                } while (this.byteBuffer.hasRemaining());
                l3 -= (long)n2;
            }
            finally {
                this.byteBuffer.clear();
            }
        }
    }

    public final void read(long l2, Buffer buffer, long l3) throws IOException {
        if (l3 < 0L) {
            throw new IndexOutOfBoundsException();
        }
        while (l3 > 0L) {
            try {
                this.byteBuffer.limit((int)Math.min(8192L, l3));
                if (this.fileChannel.read(this.byteBuffer, l2) == -1) {
                    throw new EOFException();
                }
                int n2 = this.byteBuffer.position();
                buffer.write(this.byteArray, 0, n2);
                l2 += (long)n2;
                l3 -= (long)n2;
            }
            finally {
                this.byteBuffer.clear();
            }
        }
    }
}

