/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache;

import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Editor;
import com.zoyi.io.socket.okhttp3.internal.cache.DiskLruCache$Snapshot;
import com.zoyi.io.socket.okio.BufferedSink;
import com.zoyi.io.socket.okio.Source;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;

final class DiskLruCache$Entry {
    final String key;
    final long[] lengths;
    final File[] cleanFiles;
    final File[] dirtyFiles;
    boolean readable;
    DiskLruCache$Editor currentEditor;
    long sequenceNumber;
    final /* synthetic */ DiskLruCache this$0;

    DiskLruCache$Entry(DiskLruCache diskLruCache, String charSequence) {
        this.this$0 = diskLruCache;
        this.key = charSequence;
        this.lengths = new long[diskLruCache.valueCount];
        this.cleanFiles = new File[diskLruCache.valueCount];
        this.dirtyFiles = new File[diskLruCache.valueCount];
        charSequence = new StringBuilder((String)charSequence).append('.');
        int n2 = ((StringBuilder)charSequence).length();
        for (int i2 = 0; i2 < diskLruCache.valueCount; ++i2) {
            ((StringBuilder)charSequence).append(i2);
            this.cleanFiles[i2] = new File(diskLruCache.directory, ((StringBuilder)charSequence).toString());
            ((StringBuilder)charSequence).append(".tmp");
            this.dirtyFiles[i2] = new File(diskLruCache.directory, ((StringBuilder)charSequence).toString());
            ((StringBuilder)charSequence).setLength(n2);
        }
    }

    final void setLengths(String[] stringArray) throws IOException {
        if (stringArray.length != this.this$0.valueCount) {
            throw this.invalidLengths(stringArray);
        }
        try {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.lengths[i2] = Long.parseLong(stringArray[i2]);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidLengths(stringArray);
        }
    }

    final void writeLengths(BufferedSink bufferedSink) throws IOException {
        long[] lArray = this.lengths;
        int n2 = this.lengths.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            bufferedSink.writeByte(32).writeDecimalLong(l2);
        }
    }

    private IOException invalidLengths(String[] stringArray) throws IOException {
        throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
    }

    final DiskLruCache$Snapshot snapshot() {
        if (!Thread.holdsLock(this.this$0)) {
            throw new AssertionError();
        }
        Source[] sourceArray = new Source[this.this$0.valueCount];
        long[] lArray = (long[])this.lengths.clone();
        try {
            for (int i2 = 0; i2 < this.this$0.valueCount; ++i2) {
                sourceArray[i2] = this.this$0.fileSystem.source(this.cleanFiles[i2]);
            }
            return new DiskLruCache$Snapshot(this.this$0, this.key, this.sequenceNumber, sourceArray, lArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            for (int i3 = 0; i3 < this.this$0.valueCount && sourceArray[i3] != null; ++i3) {
                Util.closeQuietly(sourceArray[i3]);
            }
            try {
                this.this$0.removeEntry(this);
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

