/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal.cache;

import com.zoyi.io.socket.okhttp3.CacheControl;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Headers$Builder;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.Response$Builder;
import com.zoyi.io.socket.okhttp3.internal.Internal;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheStrategy;
import com.zoyi.io.socket.okhttp3.internal.http.HttpDate;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class CacheStrategy$Factory {
    final long nowMillis;
    final Request request;
    final Response cacheResponse;
    private Date servedDate;
    private String servedDateString;
    private Date lastModified;
    private String lastModifiedString;
    private Date expires;
    private long sentRequestMillis;
    private long receivedResponseMillis;
    private String etag;
    private int ageSeconds = -1;

    public CacheStrategy$Factory(long l2, Request request, Response object) {
        this.nowMillis = l2;
        this.request = request;
        this.cacheResponse = object;
        if (object != null) {
            this.sentRequestMillis = ((Response)object).sentRequestAtMillis();
            this.receivedResponseMillis = ((Response)object).receivedResponseAtMillis();
            Headers headers = ((Response)object).headers();
            int n2 = headers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = headers.name(i2);
                String string = headers.value(i2);
                if ("Date".equalsIgnoreCase((String)object)) {
                    this.servedDate = HttpDate.parse(string);
                    this.servedDateString = string;
                    continue;
                }
                if ("Expires".equalsIgnoreCase((String)object)) {
                    this.expires = HttpDate.parse(string);
                    continue;
                }
                if ("Last-Modified".equalsIgnoreCase((String)object)) {
                    this.lastModified = HttpDate.parse(string);
                    this.lastModifiedString = string;
                    continue;
                }
                if ("ETag".equalsIgnoreCase((String)object)) {
                    this.etag = string;
                    continue;
                }
                if (!"Age".equalsIgnoreCase((String)object)) continue;
                this.ageSeconds = HttpHeaders.parseSeconds(string, -1);
            }
        }
    }

    public CacheStrategy get() {
        CacheStrategy cacheStrategy = this.getCandidate();
        if (cacheStrategy.networkRequest != null && this.request.cacheControl().onlyIfCached()) {
            return new CacheStrategy(null, null);
        }
        return cacheStrategy;
    }

    private CacheStrategy getCandidate() {
        String string;
        if (this.cacheResponse == null) {
            return new CacheStrategy(this.request, null);
        }
        if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
            return new CacheStrategy(this.request, null);
        }
        if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
            return new CacheStrategy(this.request, null);
        }
        Object object = this.request.cacheControl();
        if (((CacheControl)object).noCache() || CacheStrategy$Factory.hasConditions(this.request)) {
            return new CacheStrategy(this.request, null);
        }
        long l2 = this.cacheResponseAge();
        long l3 = this.computeFreshnessLifetime();
        if (((CacheControl)object).maxAgeSeconds() != -1) {
            l3 = Math.min(l3, TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds()));
        }
        long l4 = 0L;
        if (((CacheControl)object).minFreshSeconds() != -1) {
            l4 = TimeUnit.SECONDS.toMillis(((CacheControl)object).minFreshSeconds());
        }
        long l5 = 0L;
        CacheControl cacheControl = this.cacheResponse.cacheControl();
        if (!cacheControl.mustRevalidate() && ((CacheControl)object).maxStaleSeconds() != -1) {
            l5 = TimeUnit.SECONDS.toMillis(((CacheControl)object).maxStaleSeconds());
        }
        if (!cacheControl.noCache() && l2 + l4 < l3 + l5) {
            object = this.cacheResponse.newBuilder();
            if (l2 + l4 >= l3) {
                ((Response$Builder)object).addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
            }
            if (l2 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                ((Response$Builder)object).addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
            }
            return new CacheStrategy(null, ((Response$Builder)object).build());
        }
        if (this.etag != null) {
            object = "If-None-Match";
            string = this.etag;
        } else if (this.lastModified != null) {
            object = "If-Modified-Since";
            string = this.lastModifiedString;
        } else if (this.servedDate != null) {
            object = "If-Modified-Since";
            string = this.servedDateString;
        } else {
            return new CacheStrategy(this.request, null);
        }
        Headers$Builder headers$Builder = this.request.headers().newBuilder();
        Internal.instance.addLenient(headers$Builder, (String)object, string);
        object = this.request.newBuilder().headers(headers$Builder.build()).build();
        return new CacheStrategy((Request)object, this.cacheResponse);
    }

    private long computeFreshnessLifetime() {
        CacheControl cacheControl = this.cacheResponse.cacheControl();
        if (cacheControl.maxAgeSeconds() != -1) {
            return TimeUnit.SECONDS.toMillis(cacheControl.maxAgeSeconds());
        }
        if (this.expires != null) {
            long l2 = this.servedDate != null ? this.servedDate.getTime() : this.receivedResponseMillis;
            long l3 = this.expires.getTime() - l2;
            if (l3 > 0L) {
                return l3;
            }
            return 0L;
        }
        if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
            long l4 = this.servedDate != null ? this.servedDate.getTime() : this.sentRequestMillis;
            long l5 = l4 - this.lastModified.getTime();
            if (l5 > 0L) {
                return l5 / 10L;
            }
            return 0L;
        }
        return 0L;
    }

    private long cacheResponseAge() {
        long l2 = this.servedDate != null ? Math.max(0L, this.receivedResponseMillis - this.servedDate.getTime()) : 0L;
        long l3 = this.ageSeconds != -1 ? Math.max(l2, TimeUnit.SECONDS.toMillis(this.ageSeconds)) : l2;
        long l4 = this.receivedResponseMillis - this.sentRequestMillis;
        long l5 = this.nowMillis - this.receivedResponseMillis;
        return l3 + l4 + l5;
    }

    private boolean isFreshnessLifetimeHeuristic() {
        return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
    }

    private static boolean hasConditions(Request request) {
        return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
    }
}

