/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3.internal;

import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.RequestBody;
import com.zoyi.io.socket.okhttp3.ResponseBody;
import com.zoyi.io.socket.okhttp3.internal.Util$1;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSource;
import com.zoyi.io.socket.okio.ByteString;
import com.zoyi.io.socket.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Array;
import java.net.IDN;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.create(null, EMPTY_BYTE_ARRAY);
    public static final RequestBody EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
    private static final ByteString UTF_8_BOM = ByteString.decodeHex("efbbbf");
    private static final ByteString UTF_16_BE_BOM = ByteString.decodeHex("feff");
    private static final ByteString UTF_16_LE_BOM = ByteString.decodeHex("fffe");
    private static final ByteString UTF_32_BE_BOM = ByteString.decodeHex("0000ffff");
    private static final ByteString UTF_32_LE_BOM = ByteString.decodeHex("ffff0000");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset UTF_16_BE = Charset.forName("UTF-16BE");
    private static final Charset UTF_16_LE = Charset.forName("UTF-16LE");
    private static final Charset UTF_32_BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32_LE = Charset.forName("UTF-32LE");
    public static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    private Util() {
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) < 0L || l3 > l2 || l2 - l3 < l4) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static void closeQuietly(Closeable object) {
        if (object != null) {
            try {
                object.close();
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeQuietly(Socket object) {
        if (object != null) {
            try {
                ((Socket)object).close();
                return;
            }
            catch (AssertionError assertionError) {
                object = assertionError;
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw object;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static void closeQuietly(ServerSocket object) {
        if (object != null) {
            try {
                ((ServerSocket)object).close();
                return;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {}
        }
    }

    public static boolean discard(Source source, int n2, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n2, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean skipAll(Source source, int n2, TimeUnit timeUnit) throws IOException {
        long l2 = System.nanoTime();
        long l3 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l2 + Math.min(l3, timeUnit.toNanos(n2)));
        try {
            Buffer buffer = new Buffer();
            while (source.read(buffer, 8192L) != -1L) {
                buffer.clear();
            }
            return true;
        }
        catch (InterruptedIOException interruptedIOException) {
            return false;
        }
        finally {
            if (l3 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l2 + l3);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(String string, boolean bl) {
        return new Util$1(string, bl);
    }

    public static <T> T[] intersect(Class<T> clazz, T[] object, T[] TArray) {
        object = Util.intersect(object, TArray);
        return object.toArray((Object[])Array.newInstance(clazz, object.size()));
    }

    private static <T> List<T> intersect(T[] TArray, T[] TArray2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        block0: for (T t2 : TArray) {
            T[] TArray3 = TArray2;
            int n2 = TArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T t3 = TArray3[i2];
                if (!t2.equals(t3)) continue;
                arrayList.add(t3);
                continue block0;
            }
        }
        return arrayList;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        String string;
        String string2 = string = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        if (bl || httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme())) {
            return string + ":" + httpUrl.port();
        }
        return string;
    }

    public static String toHumanReadableAscii(String string) {
        int n2;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (n2 > 31 && n2 < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string, 0, i2);
            while (i2 < n3) {
                n2 = string.codePointAt(i2);
                buffer.writeUtf8CodePoint(n2 > 31 && n2 < 127 ? n2 : 63);
                i2 += Character.charCount(n2);
            }
            return buffer.readUtf8();
        }
        return string;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static <T> int indexOf(T[] TArray, T t2) {
        int n2 = TArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Util.equal(TArray[i2], t2)) continue;
            return i2;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string, int n2, int n3) {
        while (n2 < n3) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return n2;
                }
            }
            ++n2;
        }
        return n3;
    }

    public static int skipTrailingAsciiWhitespace(String string, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            switch (string.charAt(n3)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return n3 + 1;
                }
            }
            --n3;
        }
        return n2;
    }

    public static String trimSubstring(String string, int n2, int n3) {
        n2 = Util.skipLeadingAsciiWhitespace(string, n2, n3);
        n3 = Util.skipTrailingAsciiWhitespace(string, n2, n3);
        return string.substring(n2, n3);
    }

    public static int delimiterOffset(String string, int n2, int n3, String string2) {
        while (n2 < n3) {
            if (string2.indexOf(string.charAt(n2)) != -1) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int delimiterOffset(String string, int n2, int n3, char c2) {
        while (n2 < n3) {
            if (string.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static String domainToAscii(String string) {
        try {
            string = IDN.toASCII(string).toLowerCase(Locale.US);
            if (string.isEmpty()) {
                return null;
            }
            if (Util.containsInvalidHostnameAsciiCodes(string)) {
                return null;
            }
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u001f' || c2 >= '\u007f') {
                return true;
            }
            if (" #%/:?@[\\]".indexOf(c2) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyAsIpAddress(String string) {
        return VERIFY_AS_IP_ADDRESS.matcher(string).matches();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        if (bufferedSource.rangeEquals(0L, UTF_8_BOM)) {
            bufferedSource.skip(UTF_8_BOM.size());
            return UTF_8;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_BE_BOM)) {
            bufferedSource.skip(UTF_16_BE_BOM.size());
            return UTF_16_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_LE_BOM)) {
            bufferedSource.skip(UTF_16_LE_BOM.size());
            return UTF_16_LE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_BE_BOM)) {
            bufferedSource.skip(UTF_32_BE_BOM.size());
            return UTF_32_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_LE_BOM)) {
            bufferedSource.skip(UTF_32_LE_BOM.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static void throwIfFatal(Throwable throwable) {
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof LinkageError) {
            throw (LinkageError)throwable;
        }
    }
}

