/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CacheControl;
import com.zoyi.io.socket.okhttp3.Challenge;
import com.zoyi.io.socket.okhttp3.Handshake;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.Protocol;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response$Builder;
import com.zoyi.io.socket.okhttp3.ResponseBody;
import com.zoyi.io.socket.okhttp3.internal.http.HttpHeaders;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class Response
implements Closeable {
    final Request request;
    final Protocol protocol;
    final int code;
    final String message;
    final Handshake handshake;
    final Headers headers;
    final ResponseBody body;
    final Response networkResponse;
    final Response cacheResponse;
    final Response priorResponse;
    final long sentRequestAtMillis;
    final long receivedResponseAtMillis;
    private volatile CacheControl cacheControl;

    Response(Response$Builder response$Builder) {
        this.request = response$Builder.request;
        this.protocol = response$Builder.protocol;
        this.code = response$Builder.code;
        this.message = response$Builder.message;
        this.handshake = response$Builder.handshake;
        this.headers = response$Builder.headers.build();
        this.body = response$Builder.body;
        this.networkResponse = response$Builder.networkResponse;
        this.cacheResponse = response$Builder.cacheResponse;
        this.priorResponse = response$Builder.priorResponse;
        this.sentRequestAtMillis = response$Builder.sentRequestAtMillis;
        this.receivedResponseAtMillis = response$Builder.receivedResponseAtMillis;
    }

    public final Request request() {
        return this.request;
    }

    public final Protocol protocol() {
        return this.protocol;
    }

    public final int code() {
        return this.code;
    }

    public final boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public final String message() {
        return this.message;
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final List<String> headers(String string) {
        return this.headers.values(string);
    }

    public final String header(String string) {
        return this.header(string, null);
    }

    public final String header(String string, String string2) {
        if ((string = this.headers.get(string)) != null) {
            return string;
        }
        return string2;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final ResponseBody peekBody(long l2) throws IOException {
        BufferedSource bufferedSource;
        BufferedSource bufferedSource2 = this.body.source();
        bufferedSource2.request(l2);
        bufferedSource2 = bufferedSource2.buffer().clone();
        if (((Buffer)bufferedSource2).size() > l2) {
            bufferedSource = new Buffer();
            ((Buffer)bufferedSource).write((Buffer)bufferedSource2, l2);
            ((Buffer)bufferedSource2).clear();
        } else {
            bufferedSource = bufferedSource2;
        }
        return ResponseBody.create(this.body.contentType(), ((Buffer)bufferedSource).size(), bufferedSource);
    }

    public final ResponseBody body() {
        return this.body;
    }

    public final Response$Builder newBuilder() {
        return new Response$Builder(this);
    }

    public final boolean isRedirect() {
        switch (this.code) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public final Response networkResponse() {
        return this.networkResponse;
    }

    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    public final Response priorResponse() {
        return this.priorResponse;
    }

    public final List<Challenge> challenges() {
        String string;
        if (this.code == 401) {
            string = "WWW-Authenticate";
        } else if (this.code == 407) {
            string = "Proxy-Authenticate";
        } else {
            return Collections.emptyList();
        }
        return HttpHeaders.parseChallenges(this.headers(), string);
    }

    public final CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl != null) {
            return cacheControl;
        }
        this.cacheControl = CacheControl.parse(this.headers);
        return this.cacheControl;
    }

    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @Override
    public final void close() {
        this.body.close();
    }

    public final String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }
}

