/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Call;
import com.zoyi.io.socket.okhttp3.Callback;
import com.zoyi.io.socket.okhttp3.Interceptor;
import com.zoyi.io.socket.okhttp3.OkHttpClient;
import com.zoyi.io.socket.okhttp3.RealCall$AsyncCall;
import com.zoyi.io.socket.okhttp3.Request;
import com.zoyi.io.socket.okhttp3.Response;
import com.zoyi.io.socket.okhttp3.internal.cache.CacheInterceptor;
import com.zoyi.io.socket.okhttp3.internal.connection.ConnectInterceptor;
import com.zoyi.io.socket.okhttp3.internal.connection.StreamAllocation;
import com.zoyi.io.socket.okhttp3.internal.http.BridgeInterceptor;
import com.zoyi.io.socket.okhttp3.internal.http.CallServerInterceptor;
import com.zoyi.io.socket.okhttp3.internal.http.RealInterceptorChain;
import com.zoyi.io.socket.okhttp3.internal.http.RetryAndFollowUpInterceptor;
import com.zoyi.io.socket.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class RealCall
implements Call {
    final OkHttpClient client;
    final RetryAndFollowUpInterceptor retryAndFollowUpInterceptor;
    final Request originalRequest;
    final boolean forWebSocket;
    private boolean executed;

    RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
        this.retryAndFollowUpInterceptor = new RetryAndFollowUpInterceptor(okHttpClient, bl);
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Response execute() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        try {
            this.client.dispatcher().executed(this);
            object = this.getResponseWithInterceptorChain();
            if (object == null) {
                throw new IOException("Canceled");
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    private void captureCallStackTrace() {
        Object object = Platform.get().getStackTraceForCloseable("response.body().close()");
        this.retryAndFollowUpInterceptor.setCallStackTrace(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enqueue(Callback callback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        this.client.dispatcher().enqueue(new RealCall$AsyncCall(this, callback));
    }

    @Override
    public final void cancel() {
        this.retryAndFollowUpInterceptor.cancel();
    }

    @Override
    public final synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public final boolean isCanceled() {
        return this.retryAndFollowUpInterceptor.isCanceled();
    }

    @Override
    public final RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    final StreamAllocation streamAllocation() {
        return this.retryAndFollowUpInterceptor.streamAllocation();
    }

    final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl();
    }

    final String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    final Response getResponseWithInterceptorChain() throws IOException {
        Object object = new ArrayList<Interceptor>();
        object.addAll(this.client.interceptors());
        object.add(this.retryAndFollowUpInterceptor);
        object.add(new BridgeInterceptor(this.client.cookieJar()));
        object.add(new CacheInterceptor(this.client.internalCache()));
        object.add(new ConnectInterceptor(this.client));
        if (!this.forWebSocket) {
            object.addAll(this.client.networkInterceptors());
        }
        object.add(new CallServerInterceptor(this.forWebSocket));
        object = new RealInterceptorChain((List<Interceptor>)object, null, null, null, 0, this.originalRequest);
        return object.proceed(this.originalRequest);
    }
}

