/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.MediaType;
import com.zoyi.io.socket.okhttp3.RequestBody;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okio.Buffer;
import com.zoyi.io.socket.okio.BufferedSink;
import java.io.IOException;
import java.util.List;

public final class FormBody
extends RequestBody {
    private static final MediaType CONTENT_TYPE = MediaType.parse("application/x-www-form-urlencoded");
    private final List<String> encodedNames;
    private final List<String> encodedValues;

    FormBody(List<String> list, List<String> list2) {
        this.encodedNames = Util.immutableList(list);
        this.encodedValues = Util.immutableList(list2);
    }

    public final int size() {
        return this.encodedNames.size();
    }

    public final String encodedName(int n2) {
        return this.encodedNames.get(n2);
    }

    public final String name(int n2) {
        return HttpUrl.percentDecode(this.encodedName(n2), true);
    }

    public final String encodedValue(int n2) {
        return this.encodedValues.get(n2);
    }

    public final String value(int n2) {
        return HttpUrl.percentDecode(this.encodedValue(n2), true);
    }

    @Override
    public final MediaType contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public final long contentLength() {
        return this.writeOrCountBytes(null, true);
    }

    @Override
    public final void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    private long writeOrCountBytes(BufferedSink bufferedSink, boolean bl) {
        long l2 = 0L;
        bufferedSink = bl ? new Buffer() : bufferedSink.buffer();
        int n2 = this.encodedNames.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                ((Buffer)bufferedSink).writeByte(38);
            }
            ((Buffer)bufferedSink).writeUtf8(this.encodedNames.get(i2));
            ((Buffer)bufferedSink).writeByte(61);
            ((Buffer)bufferedSink).writeUtf8(this.encodedValues.get(i2));
        }
        if (bl) {
            l2 = ((Buffer)bufferedSink).size();
            ((Buffer)bufferedSink).clear();
        }
        return l2;
    }
}

