/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.Cookie$Builder;
import com.zoyi.io.socket.okhttp3.Headers;
import com.zoyi.io.socket.okhttp3.HttpUrl;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Cookie {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String string, String string2, long l2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string;
        this.value = string2;
        this.expiresAt = l2;
        this.domain = string3;
        this.path = string4;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    Cookie(Cookie$Builder cookie$Builder) {
        if (cookie$Builder.name == null) {
            throw new NullPointerException("builder.name == null");
        }
        if (cookie$Builder.value == null) {
            throw new NullPointerException("builder.value == null");
        }
        if (cookie$Builder.domain == null) {
            throw new NullPointerException("builder.domain == null");
        }
        this.name = cookie$Builder.name;
        this.value = cookie$Builder.value;
        this.expiresAt = cookie$Builder.expiresAt;
        this.domain = cookie$Builder.domain;
        this.path = cookie$Builder.path;
        this.secure = cookie$Builder.secure;
        this.httpOnly = cookie$Builder.httpOnly;
        this.persistent = cookie$Builder.persistent;
        this.hostOnly = cookie$Builder.hostOnly;
    }

    public final String name() {
        return this.name;
    }

    public final String value() {
        return this.value;
    }

    public final boolean persistent() {
        return this.persistent;
    }

    public final long expiresAt() {
        return this.expiresAt;
    }

    public final boolean hostOnly() {
        return this.hostOnly;
    }

    public final String domain() {
        return this.domain;
    }

    public final String path() {
        return this.path;
    }

    public final boolean httpOnly() {
        return this.httpOnly;
    }

    public final boolean secure() {
        return this.secure;
    }

    public final boolean matches(HttpUrl httpUrl) {
        boolean bl = this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl, this.domain);
        if (!bl) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    private static boolean domainMatch(HttpUrl object, String string) {
        if (((String)(object = ((HttpUrl)object).host())).equals(string)) {
            return true;
        }
        return ((String)object).endsWith(string) && ((String)object).charAt(((String)object).length() - string.length() - 1) == '.' && !Util.verifyAsIpAddress((String)object);
    }

    private static boolean pathMatch(HttpUrl object, String string) {
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string)) {
            return true;
        }
        if (((String)object).startsWith(string)) {
            if (string.endsWith("/")) {
                return true;
            }
            if (((String)object).charAt(string.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    public static Cookie parse(HttpUrl httpUrl, String string) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string);
    }

    static Cookie parse(long l2, HttpUrl httpUrl, String string) {
        long l3;
        int n2;
        int n3 = string.length();
        int n4 = Util.delimiterOffset(string, 0, n3, ';');
        int n5 = Util.delimiterOffset(string, 0, n4, '=');
        if (n5 == n4) {
            return null;
        }
        String string2 = Util.trimSubstring(string, 0, n5);
        if (string2.isEmpty()) {
            return null;
        }
        String string3 = Util.trimSubstring(string, n5 + 1, n4);
        long l4 = 253402300799999L;
        long l5 = -1L;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        ++n4;
        while (n4 < n3) {
            String string6;
            int n6 = Util.delimiterOffset(string, n4, n3, ';');
            n2 = Util.delimiterOffset(string, n4, n6, '=');
            String string7 = Util.trimSubstring(string, n4, n2);
            String string8 = string6 = n2 < n6 ? Util.trimSubstring(string, n2 + 1, n6) : "";
            if (string7.equalsIgnoreCase("expires")) {
                try {
                    l4 = Cookie.parseExpires(string6, 0, string6.length());
                    bl4 = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("max-age")) {
                try {
                    l5 = Cookie.parseMaxAge(string6);
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string7.equalsIgnoreCase("domain")) {
                try {
                    string4 = Cookie.parseDomain(string6);
                    bl3 = false;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (string7.equalsIgnoreCase("path")) {
                string5 = string6;
            } else if (string7.equalsIgnoreCase("secure")) {
                bl = true;
            } else if (string7.equalsIgnoreCase("httponly")) {
                bl2 = true;
            }
            n4 = n6 + 1;
        }
        if (l5 == Long.MIN_VALUE) {
            l4 = Long.MIN_VALUE;
        } else if (l5 != -1L && ((l4 = l2 + (l3 = l5 <= 9223372036854775L ? l5 * 1000L : Long.MAX_VALUE)) < l2 || l4 > 253402300799999L)) {
            l4 = 253402300799999L;
        }
        if (string4 == null) {
            string4 = httpUrl.host();
        } else if (!Cookie.domainMatch(httpUrl, string4)) {
            return null;
        }
        if (string5 == null || !string5.startsWith("/")) {
            String string9 = httpUrl.encodedPath();
            n2 = string9.lastIndexOf(47);
            string5 = n2 != 0 ? string9.substring(0, n2) : "/";
        }
        return new Cookie(string2, string3, l4, string4, string5, bl, bl2, bl3, bl4);
    }

    private static long parseExpires(String string, int n2, int n3) {
        n2 = Cookie.dateCharacterOffset(string, n2, n3, false);
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        Matcher matcher = TIME_PATTERN.matcher(string);
        while (n2 < n3) {
            int n10 = Cookie.dateCharacterOffset(string, n2 + 1, n3, true);
            matcher.region(n2, n10);
            if (n4 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n4 = Integer.parseInt(matcher.group(1));
                n5 = Integer.parseInt(matcher.group(2));
                n6 = Integer.parseInt(matcher.group(3));
            } else if (n7 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n7 = Integer.parseInt(matcher.group(1));
            } else if (n8 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                String string2 = matcher.group(1).toLowerCase(Locale.US);
                n8 = MONTH_PATTERN.pattern().indexOf(string2) / 4;
            } else if (n9 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n9 = Integer.parseInt(matcher.group(1));
            }
            n2 = Cookie.dateCharacterOffset(string, n10 + 1, n3, false);
        }
        if (n9 >= 70 && n9 <= 99) {
            n9 += 1900;
        }
        if (n9 >= 0 && n9 <= 69) {
            n9 += 2000;
        }
        if (n9 < 1601) {
            throw new IllegalArgumentException();
        }
        if (n8 == -1) {
            throw new IllegalArgumentException();
        }
        if (n7 <= 0 || n7 > 31) {
            throw new IllegalArgumentException();
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException();
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException();
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
        gregorianCalendar.setLenient(false);
        gregorianCalendar.set(1, n9);
        gregorianCalendar.set(2, n8 - 1);
        gregorianCalendar.set(5, n7);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTimeInMillis();
    }

    private static int dateCharacterOffset(String string, int n2, int n3, boolean bl) {
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            c2 = c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':' ? (char)'\u0001' : '\u0000';
            if (c2 == (!bl ? (char)'\u0001' : '\u0000')) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    private static long parseMaxAge(String string) {
        try {
            long l2 = Long.parseLong(string);
            if (l2 <= 0L) {
                return Long.MIN_VALUE;
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches("-?\\d+")) {
                if (string.startsWith("-")) {
                    return Long.MIN_VALUE;
                }
                return Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String string) {
        if (string.endsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if ((string = Util.domainToAscii(string)) == null) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers object) {
        object = ((Headers)object).values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cookie cookie = Cookie.parse(httpUrl, (String)object.get(i2));
            if (cookie == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        if (arrayList != null) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    public final String toString() {
        return this.toString(false);
    }

    final String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=").append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append("; domain=");
            if (bl) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append("; path=").append(this.path);
        if (this.secure) {
            stringBuilder.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        object = (Cookie)object;
        return ((Cookie)object).name.equals(this.name) && ((Cookie)object).value.equals(this.value) && ((Cookie)object).domain.equals(this.domain) && ((Cookie)object).path.equals(this.path) && ((Cookie)object).expiresAt == this.expiresAt && ((Cookie)object).secure == this.secure && ((Cookie)object).httpOnly == this.httpOnly && ((Cookie)object).persistent == this.persistent && ((Cookie)object).hostOnly == this.hostOnly;
    }

    public final int hashCode() {
        int n2 = 527 + this.name.hashCode();
        n2 = n2 * 31 + this.value.hashCode();
        n2 = n2 * 31 + this.domain.hashCode();
        n2 = n2 * 31 + this.path.hashCode();
        n2 = n2 * 31 + (int)(this.expiresAt ^ this.expiresAt >>> 32);
        n2 = n2 * 31 + (this.secure ? 0 : 1);
        n2 = n2 * 31 + (this.httpOnly ? 0 : 1);
        n2 = n2 * 31 + (this.persistent ? 0 : 1);
        n2 = n2 * 31 + (this.hostOnly ? 0 : 1);
        return n2;
    }
}

