/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CipherSuite;
import com.zoyi.io.socket.okhttp3.ConnectionSpec;
import com.zoyi.io.socket.okhttp3.TlsVersion;

public final class ConnectionSpec$Builder {
    boolean tls;
    String[] cipherSuites;
    String[] tlsVersions;
    boolean supportsTlsExtensions;

    ConnectionSpec$Builder(boolean bl) {
        this.tls = bl;
    }

    public ConnectionSpec$Builder(ConnectionSpec connectionSpec) {
        this.tls = connectionSpec.tls;
        this.cipherSuites = connectionSpec.cipherSuites;
        this.tlsVersions = connectionSpec.tlsVersions;
        this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
    }

    public final ConnectionSpec$Builder allEnabledCipherSuites() {
        if (!this.tls) {
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }
        this.cipherSuites = null;
        return this;
    }

    public final ConnectionSpec$Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
        if (!this.tls) {
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }
        String[] stringArray = new String[cipherSuiteArray.length];
        for (int i2 = 0; i2 < cipherSuiteArray.length; ++i2) {
            stringArray[i2] = cipherSuiteArray[i2].javaName;
        }
        return this.cipherSuites(stringArray);
    }

    public final ConnectionSpec$Builder cipherSuites(String ... stringArray) {
        if (!this.tls) {
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("At least one cipher suite is required");
        }
        this.cipherSuites = (String[])stringArray.clone();
        return this;
    }

    public final ConnectionSpec$Builder allEnabledTlsVersions() {
        if (!this.tls) {
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }
        this.tlsVersions = null;
        return this;
    }

    public final ConnectionSpec$Builder tlsVersions(TlsVersion ... tlsVersionArray) {
        if (!this.tls) {
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }
        String[] stringArray = new String[tlsVersionArray.length];
        for (int i2 = 0; i2 < tlsVersionArray.length; ++i2) {
            stringArray[i2] = tlsVersionArray[i2].javaName;
        }
        return this.tlsVersions(stringArray);
    }

    public final ConnectionSpec$Builder tlsVersions(String ... stringArray) {
        if (!this.tls) {
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("At least one TLS version is required");
        }
        this.tlsVersions = (String[])stringArray.clone();
        return this;
    }

    public final ConnectionSpec$Builder supportsTlsExtensions(boolean bl) {
        if (!this.tls) {
            throw new IllegalStateException("no TLS extensions for cleartext connections");
        }
        this.supportsTlsExtensions = bl;
        return this;
    }

    public final ConnectionSpec build() {
        return new ConnectionSpec(this);
    }
}

