/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.io.socket.okhttp3;

import com.zoyi.io.socket.okhttp3.CertificatePinner$Builder;
import com.zoyi.io.socket.okhttp3.CertificatePinner$Pin;
import com.zoyi.io.socket.okhttp3.internal.Util;
import com.zoyi.io.socket.okhttp3.internal.tls.CertificateChainCleaner;
import com.zoyi.io.socket.okio.ByteString;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new CertificatePinner$Builder().build();
    private final Set<CertificatePinner$Pin> pins;
    private final CertificateChainCleaner certificateChainCleaner;

    CertificatePinner(Set<CertificatePinner$Pin> set, CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof CertificatePinner && Util.equal(this.certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner) && this.pins.equals(((CertificatePinner)object).pins);
    }

    public final int hashCode() {
        int n2 = this.certificateChainCleaner != null ? this.certificateChainCleaner.hashCode() : 0;
        n2 = n2 * 31 + this.pins.hashCode();
        return n2;
    }

    public final void check(String string, List<Certificate> list) throws SSLPeerUnverifiedException {
        Object object;
        List<CertificatePinner$Pin> list2 = this.findMatchingPins(string);
        if (list2.isEmpty()) {
            return;
        }
        if (this.certificateChainCleaner != null) {
            list = this.certificateChainCleaner.clean(list, string);
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i2);
            object = null;
            ByteString byteString = null;
            int n3 = list2.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                CertificatePinner$Pin certificatePinner$Pin = list2.get(i3);
                if (certificatePinner$Pin.hashAlgorithm.equals("sha256/")) {
                    if (byteString == null) {
                        byteString = CertificatePinner.sha256(x509Certificate);
                    }
                    if (!certificatePinner$Pin.hash.equals(byteString)) continue;
                    return;
                }
                if (certificatePinner$Pin.hashAlgorithm.equals("sha1/")) {
                    if (object == null) {
                        object = CertificatePinner.sha1(x509Certificate);
                    }
                    if (!certificatePinner$Pin.hash.equals(object)) continue;
                    return;
                }
                throw new AssertionError();
            }
        }
        StringBuilder stringBuilder = new StringBuilder("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = (X509Certificate)list.get(n2);
            stringBuilder.append("\n    ").append(CertificatePinner.pin((Certificate)object)).append(": ").append(((X509Certificate)object).getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string).append(":");
        n4 = list2.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = list2.get(n2);
            stringBuilder.append("\n    ").append(object);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public final void check(String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string, Arrays.asList(certificateArray));
    }

    final List<CertificatePinner$Pin> findMatchingPins(String string) {
        List<CertificatePinner$Pin> list = Collections.emptyList();
        for (CertificatePinner$Pin certificatePinner$Pin : this.pins) {
            if (!certificatePinner$Pin.matches(string)) continue;
            if (list.isEmpty()) {
                list = new ArrayList<CertificatePinner$Pin>();
            }
            list.add(certificatePinner$Pin);
        }
        return list;
    }

    final CertificatePinner withCertificateChainCleaner(CertificateChainCleaner certificateChainCleaner) {
        if (Util.equal(this.certificateChainCleaner, certificateChainCleaner)) {
            return this;
        }
        return new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public static String pin(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
        }
        return "sha256/" + CertificatePinner.sha256((X509Certificate)certificate).base64();
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }
}

